//  Copyright (C) 2011 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef REINFORCEMENT_POINT_H
#define REINFORCEMENT_POINT_H
#include <string>
#include "xmlhelper.h"
#include "vector.h"
#include <gtkmm.h>
#include "OwnerId.h"
#include "Immovable.h"
#include "player.h"
class ReinforcementPoint: public OwnerId, public Immovable
{
    public:
	//! The xml tag of this object in a saved-game file.
	static std::string d_tag; 

        ReinforcementPoint(Vector<int> pos, Player *owner);

	//! Copy constructor.
        ReinforcementPoint(const ReinforcementPoint&);

        //! Loading constructor.
        ReinforcementPoint(XML_Helper* helper);

	//! Destructor.
        ~ReinforcementPoint();

        //! Save the road data to an opened saved-game file.
        bool save(XML_Helper* helper) const;


	// Static Methods

    protected:

	// DATA

};

#endif // REINFORCEMENT_POINT_H
