// Copyright (C) 2011, 2014 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include <stdlib.h>
#include <time.h>

#include "Configuration.h"
#include "File.h"
#include "GraphicsCache.h"
#include "armyset.h"

#include "gui/main.h"
#include <gstreamermm/init.h>

using namespace std;


int max_vector_width;
int main(int argc, char* argv[])
{
  srand(time(NULL));         // set the random seed

  initialize_configuration();
  Vector<int>::setMaximumWidth(1000);

  Main kit(argc, argv);
  Gst::init(argc, argv);

  if (argc > 1)
    {
      for (int i = 2; i <= argc; i++)
	{
	  string parameter(argv[i-1]); 
	  if (parameter == "--seed" || parameter == "-S")
	    {
	      i++;
	      //convert the next argument
	      char* error = 0;
	      long seed = strtol(argv[i-1], &error, 10);
	      if (error && (*error != '\0'))
		{
		  cerr <<"non-numerical value for --seed" <<endl;
		  exit(-1);
		}
              kit.random_number_seed = seed;
	      srand(seed);
	    }
	  else if (parameter == "--help" || parameter == "-h")
	    {
	      cout << Glib::get_prgname() << " [OPTION]... [FILE]" << endl << endl;
	      cout << "ARMY " << "version" << " " << VERSION << endl << endl;
	      cout << "Options:" << endl << endl; 
	      cout << "  -h, --help                 " << "Shows this help screen" <<endl;
	      cout << "  -S, --seed <number>        " << "Seed the random number generator with NUMBER" << endl;
	      cout << endl;
	      cout << "FILE can be a saved game file (.sav), or a map (.map) file." << endl;
	      cout << endl;
	      cout << "Report bugs to" << " <" << PACKAGE_BUGREPORT ">." << endl;
	      exit(0);
	    }
	  else
	    kit.load_filename = parameter;
	}
    }

  // Check if armysets are in the path (otherwise exit)
  Armyset::scanSystemCollection();

  kit.start_main_loop();

  return EXIT_SUCCESS;
}
