//  Copyright (C) 2011 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef RAFT_H
#define RAFT_H
#include <string>
#include "xmlhelper.h"
#include "vector.h"
#include <gtkmm.h>
class Raft
{
    public:
	//! The xml tag of this object in a saved-game file.
	static std::string d_tag; 

        Raft(Vector<int> pos, Vector<int> dest);

	//! Copy constructor.
        Raft(const Raft&);

        //! Loading constructor.
        Raft(XML_Helper* helper);

	//! Destructor.
        ~Raft();


	// Get Methods

        Vector<int> getPos() const {return isAtDestination() ? getDestinationPos(): getSourcePos();};
        Vector<int> getOtherPos() const {return isAtDestination() ? getSourcePos(): getDestinationPos();};
        Vector<int> getSourcePos() const {return d_src;};
        Vector<int> getDestinationPos() const { return d_dest;};
        bool isAtDestination() const {return d_is_at_destination;};

	// Set Methods

        void setAtDestination(bool d) { d_is_at_destination = d;};

	// Methods that operate on class data but do not modify the class

        //! Save the road data to an opened saved-game file.
        bool save(XML_Helper* helper) const;


	// Static Methods

    protected:

	// DATA

        Vector<int> d_src;
        Vector<int> d_dest;
        bool d_is_at_destination;

};

#endif // RAFT_H
