// Copyright (C) 2014 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef SND_H
#define SND_H

#include "xmlhelper.h"

#include <string>
#include <map>
#include <sigc++/trackable.h>
#include <gstreamermm/playbin2.h>
#include "soundset.h"

class Snd : public sigc::trackable
{
    public:

	// Methods that operate on class data and modify the class.

        void play(std::string piece);
        
	// Static Methods

        //! Singleton getter
        static Snd* getInstance();

        //! Explicitely delete the singleton
        static void deleteInstance();

        void loadSoundset(Soundset *soundset);
        Soundset *getSoundset() const {return d_soundset;}
    private:
        //! Constructor.  Initializes the sound and loads the music data
        Snd();

        //! Destructor.  Deinitializes sound
        ~Snd();

	// DATA
        Soundset *d_soundset;
        Glib::RefPtr<Gst::PlayBin2> playbin;


        // static instanton pointer
        static Snd* s_instance;
};

#endif //SND_H
