// Copyright (C) 2011, 2014 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <iostream>
#include <sigc++/functors/mem_fun.h>
#include "soundset.h"
#include "File.h"
#include "defs.h"

Soundset::Soundset()
{
}

Soundset::~Soundset()
{
}

bool Soundset::save(XML_Helper* helper) const
{
    bool retval = true;

    retval &= helper->begin (ARMY_MUSIC_VERSION);
    retval &= helper->openTag("music");

    for (std::map<std::string,MusicItem*>::const_iterator it = d_musicMap.begin(); it != d_musicMap.end(); it++)
      {
        retval &= helper->openTag("piece");
        retval &= helper->saveData("name", (*it).first);
        retval &= helper->saveData("filename", File::get_basename((*it).second->file, true));
        retval &= helper->saveData("alias", (*it).second->alias);
        retval &= helper->closeTag();
      }
    
    retval &= helper->closeTag();

    return retval;
}
        
Soundset::Soundset(XML_Helper *helper)
{
  helper->registerTag("piece", sigc::mem_fun((*this), &Soundset::loadMusic));
}

bool Soundset::loadMusic(std::string tag, XML_Helper* helper)
{
  if (tag != "piece")
    {
      std::cerr <<"Loading music: Wrong tag name\n";
      return false;
    }

  std::string tagname;
  MusicItem* item = new MusicItem();

  bool retval = true;
  retval &= helper->getData(tagname, "name");
  retval &= helper->getData(item->file, "filename");
  retval &= helper->getData(item->alias, "alias");

  if (retval)
    d_musicMap[tagname] = item;

  return retval;
}
        
void Soundset::setPieces(std::map<std::string, MusicItem*> map)
{
  d_musicMap = map;
}

void Soundset::getFilenames(std::list<std::string> &files) const
{
  for (std::map<std::string,MusicItem*>::const_iterator i = d_musicMap.begin(); 
       i != d_musicMap.end(); i++)
    files.push_back((*i).second->file);
}
        
std::string Soundset::getPieceFilename(std::string piecename) const
{
  for (std::map<std::string,MusicItem*>::const_iterator i = d_musicMap.begin(); 
       i != d_musicMap.end(); i++)
    {
      if ((*i).first == piecename)
        return (*i).second->file;
    }
  return "";
}
