// Copyright (C) 2011 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include "NextTurnHotseat.h"

#include "playerlist.h"

using namespace std;
#define debug(x) {cerr<<__FILE__<<": "<<__LINE__<<": "<<x<<flush<<endl;}
//#define debug(x)

NextTurnHotseat::NextTurnHotseat()
    :NextTurn()
{
  continuing_turn = false;
  
  Playerlist* plist = Playerlist::getInstance();
  for (Playerlist::iterator i = plist->begin(); i != plist->end(); ++i) {
    Player *p = *i;
    p->ending_turn.connect(sigc::mem_fun(this, &NextTurn::endTurn));
  }
}

NextTurnHotseat::~NextTurnHotseat()
{
}

void NextTurnHotseat::start()
{
    //We need the playerlist a lot, so maintain a copy of it.

    //set first player as active if no active player exists
    if (!Playerlist::getActiveplayer())
      nextPlayer();
	
    while (!d_stop)
    {
      supdating.emit();

        // do various start-up tasks
        if (continuing_turn)
	  {
	    continuing_turn = false;
	    return;
	  }

	startTurn();
       
	// inform everyone about the next turn 
	snextTurn.emit(Playerlist::getActiveplayer());
    
	splayerStart.emit(Playerlist::getActiveplayer());

	// let the player do his or her duties...
	bool continue_loop = Playerlist::getActiveplayer()->startTurn();
	if (!continue_loop || d_stop)
	  return;
	
	//Now do some cleanup at the end of the turn.
	finishTurn();

        //...and initiate the next one.
	nextPlayer();
        
        //if it is the first player's turn now, a new round has started
        if (Playerlist::getInstance()->getActiveplayer() == 
	    Playerlist::getInstance()->getFirstLiving())
        
	  {
	    if (Playerlist::getInstance()->checkPlayers() == true)
	      {
		if (Playerlist::getInstance()->getNoOfPlayers() <= 1)
		  break;
		if (Playerlist::getActiveplayer()->isDead())
		  nextPlayer();
	      }
	    finishRound();
	    snextRound.emit();
	  }
    }
}

void NextTurnHotseat::endTurn()
{
  // Finish off the player and transfers the control to the start function
  // again.
  finishTurn();
  if (Playerlist::getInstance()->checkPlayers() == true)
    {
      if (d_stop)
	return;
      if (Playerlist::getInstance()->getNoOfPlayers() <= 1)
	return;
    }
  nextPlayer();

  //this is problematic when the first player dies.
  //end the turn if all living players have ended their turn.
  if (Playerlist::getInstance()->isEndOfRound() == true)
    {
      finishRound();
      snextRound.emit();
    }

  start();
}

void NextTurnHotseat::startTurn()
{
  Player* p = Playerlist::getActiveplayer();
  p->initTurn();
}

void NextTurnHotseat::finishTurn()
{
  Player *p = Playerlist::getActiveplayer();
  p->endTurn();
}

void NextTurnHotseat::finishRound()
{

}
