// Copyright (C) 2011, 2014 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef AI_DUMMY_H
#define AI_DUMMY_H

#include <string>
#include <list>
#include <gtkmm.h>

#include "real_player.h"

class XML_Helper;

//! A simple artificial intelligence Player suitable to be the neutral Player.
/** 
 * This class is a dummy AI used for the neutral player. It just does, well,
 * nothing.
 */

class AI_Dummy : public RealPlayer
{
    public:
        /** 
	 * Make a new AI_Dummy player.
         * 
         * @param name         The name of the player.
         * @param armyset      The Id of the player's Armyset.
         * @param color        The player's colour.
	 * @param player_no    The Id of the player.  If this value is -1,
	 *                     the next free Id it used.
         */
	//! Default constructor.
        AI_Dummy (Glib::ustring name, guint32 armyset, Gdk::RGBA color, 
		  int player_no = -1);

	//! Copy constructor.
        AI_Dummy(const Player& player);
        //! Loading constructor. See XML_Helper.
        AI_Dummy(XML_Helper* helper);
	//! Destructor.
        ~AI_Dummy();
        
	virtual bool isComputer() const {return true;};
        virtual void abortTurn();
        virtual bool startTurn();

    private:
	//DATA
};

#endif // AI_DUMMY_H
