// Copyright (C) 2011, 2014 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include <iostream>
#include <sstream>
#include <algorithm>
#include "armyproto.h"
#include "xmlhelper.h"
#include "armyset.h"
#include "tarhelper.h"

//#define debug(x) {std::cerr<<__FILE__<<": "<<__LINE__<<": "<<x<<std::endl<<std::flush;}
#define debug(x)
Glib::ustring ArmyProto::d_tag = "armyproto";

ArmyProto::ArmyProto(const ArmyProto& a)
    :ArmyProtoBase(a), d_image_name(a.d_image_name)
{
  for (unsigned int c = Shield::BLUE; c <= Shield::RED; c++)
    {
      d_image_name[c] = a.d_image_name[c];
      d_image[c] = a.d_image[c];
    }
}

ArmyProto::ArmyProto()
  :ArmyProtoBase()
{
  for (unsigned int c = Shield::BLUE; c <= Shield::RED; c++)
    {
      d_image_name[c] = "";
      d_image[c] = NULL;
    }
}

ArmyProto::ArmyProto(XML_Helper* helper)
  :ArmyProtoBase(helper)
{
  helper->getData(d_image_name[Shield::BLUE], "image_blue");
  helper->getData(d_image_name[Shield::RED], "image_red");
  for (unsigned int c = Shield::BLUE; c <= Shield::RED; c++)
    {
      d_image[c] = NULL;
    }
}

ArmyProto::~ArmyProto()
{
}

bool ArmyProto::save(XML_Helper* helper) const
{
  bool retval = true;

  retval &= helper->openTag(d_tag);

  retval &= saveData(helper);

  retval &= helper->closeTag();

  return retval;
}

bool ArmyProto::saveData(XML_Helper* helper) const
{
  bool retval = true;

  retval &= ArmyProtoBase::saveData(helper);
  retval &= helper->saveData("image_blue", d_image_name[Shield::BLUE]);
  retval &= helper->saveData("image_red", d_image_name[Shield::RED]);

  return retval;
}

void ArmyProto::instantiateImages(int tilesize, Shield::Colour c, Glib::ustring image_filename, bool &broken)
{
  Glib::ustring s;

  if (image_filename == "")
    {
      broken = true;
      return;
    }
  setImage(c, PixMask::create(image_filename, broken));
  return;
}

void ArmyProto::instantiateImages(guint32 tilesize, Tar_Helper *t, bool &broken)
{
  broken = false;
  for (unsigned int c = Shield::BLUE; c <= Shield::RED; c++)
    {
      Glib::ustring file = "";
      if (getImageName(Shield::Colour(c)).empty() == false)
	file = t->getFile(getImageName(Shield::Colour(c)) + ".png", broken);
      if (!broken && file.empty() == false)
        instantiateImages(tilesize, Shield::Colour(c), file, broken);
      if (file.empty() == false)
        File::erase(file);
    }
}

void ArmyProto::uninstantiateImages()
{
  for (unsigned int c = Shield::BLUE; c <= Shield::RED; c++)
    {
      if (getImage(Shield::Colour(c)))
	{
	  delete getImage(Shield::Colour(c));
	  setImage(Shield::Colour(c), NULL);
	}
    }
}

