// Copyright (C) 2011 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include <iostream>
#include <sstream>
#include <algorithm>
#include "armyprotobase.h"
#include "xmlhelper.h"
#include "defs.h"

//#define debug(x) {std::cerr<<__FILE__<<": "<<__LINE__<<": "<<x<<std::endl<<std::flush;}
#define debug(x)

ArmyProtoBase::ArmyProtoBase(const ArmyProtoBase& a)
    :ArmyBase(a), d_name(a.d_name), d_type_id(a.d_type_id),
    d_description(a.d_description), d_armyset(a.d_armyset),
    d_move_bonus(a.d_move_bonus), d_max_moves(a.d_max_moves),
    d_attack_bonus(a.d_attack_bonus), d_power_bonus(a.d_power_bonus),
    d_can_attack_across_water(a.d_can_attack_across_water),
    d_attack_bonus_water_penalty(a.d_attack_bonus_water_penalty),
    d_can_move_across_water(a.d_can_move_across_water),
    d_can_attack_over_enemies(a.d_can_attack_over_enemies),
    d_can_destroy_brick(a.d_can_destroy_brick),
    d_minimum_die_to_break_brick(a.d_minimum_die_to_break_brick),
    d_winning_piece(a.d_winning_piece)
{
}

ArmyProtoBase::ArmyProtoBase()
  :ArmyBase(), d_name("Untitled"), d_type_id(0),
    d_description(""), d_armyset(0), d_move_bonus(0), d_max_moves(-1),
    d_attack_bonus(0), d_power_bonus(0), d_can_attack_across_water(false),
    d_attack_bonus_water_penalty(0.0), d_can_move_across_water(false),
    d_can_attack_over_enemies(false), d_can_destroy_brick(false),
    d_minimum_die_to_break_brick(0), d_winning_piece(false)
{
}

ArmyProtoBase::ArmyProtoBase(XML_Helper* helper)
  :ArmyBase(helper), d_name(""), d_type_id(0), 
    d_description(""), d_armyset(0), d_move_bonus(0), d_max_moves(-1),
    d_attack_bonus(0), d_power_bonus(0), d_can_attack_across_water(false),
    d_attack_bonus_water_penalty(0.0), d_can_move_across_water(false),
    d_can_attack_over_enemies(false), d_can_destroy_brick(false),
    d_minimum_die_to_break_brick(0), d_winning_piece(false)
{


  helper->getData(d_name, "name");
  helper->getData(d_description, "description");
  helper->getData(d_move_bonus, "move_bonus");
  helper->getData(d_max_moves, "max_moves");
  helper->getData(d_attack_bonus, "attack_bonus");
  helper->getData(d_power_bonus, "power_bonus");
  helper->getData(d_can_attack_across_water, "can_attack_across_water");
  helper->getData(d_attack_bonus_water_penalty, "attack_bonus_water_penalty");
  helper->getData(d_can_move_across_water, "can_move_across_water");
  helper->getData(d_can_attack_over_enemies, "can_attack_over_enemies");
  helper->getData(d_can_destroy_brick, "can_destroy_brick");
  helper->getData(d_minimum_die_to_break_brick, "minimum_die_to_break_brick");
  helper->getData(d_winning_piece, "winning_piece");
}

ArmyProtoBase::~ArmyProtoBase()
{
}

bool ArmyProtoBase::saveData(XML_Helper* helper) const
{
  bool retval = true;

  retval &= helper->saveData("name", d_name);
  retval &= helper->saveData("description", d_description);
  retval &= helper->saveData("move_bonus", d_move_bonus);
  retval &= helper->saveData("max_moves", d_max_moves);
  retval &= helper->saveData("attack_bonus", d_attack_bonus);
  retval &= helper->saveData("power_bonus", d_power_bonus);
  retval &= helper->saveData("can_attack_across_water", 
                             d_can_attack_across_water);
  retval &= helper->saveData("attack_bonus_water_penalty", 
                             d_attack_bonus_water_penalty);
  retval &= helper->saveData("can_move_across_water", 
                             d_can_move_across_water);
  retval &= helper->saveData("can_attack_over_enemies", 
                             d_can_attack_over_enemies);
  retval &= helper->saveData("can_destroy_brick", 
                             d_can_destroy_brick);
  retval &= helper->saveData("minimum_die_to_break_brick", 
                             d_minimum_die_to_break_brick);
  retval &= helper->saveData("winning_piece", d_winning_piece);
  retval &= ArmyBase::saveData(helper);
  return retval;
}
