//  Copyright (C) 2011, 2014 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef CONFIGURATION_H
#define CONFIGURATION_H

#include <gtkmm.h>
#include <sigc++/trackable.h>

class XML_Helper;

#include "game-parameters.h"

void initialize_configuration();

class Configuration : public sigc::trackable
{
    public:

        static Glib::ustring d_tag;

        // CREATORS
        Configuration();
        ~Configuration();

        /** \brief Load a configuration file
          * 
          * @param fileName     the full name of the config file
          *
          * This class loads an xml-style config file and sets the settings
          * appropriately.
          */
        bool loadConfigurationFile(Glib::ustring fileName);

        /** \brief Save the configuration file
          * 
          * @param fileName     the full name of the config file
          *
          * This class saves the current config to an xml-style config file.
          */
        static bool saveConfigurationFile(Glib::ustring filename);

        static Glib::ustring configuration_file_path;
	
        //the paths
        static Glib::ustring s_dataPath;
        static Glib::ustring s_savePath;

        // music settings; the cache size is given in pieces instead of memory
        static bool s_musicenable;

    private:
        /** \brief The callback for the XML_Helper
          * 
          * See the XML_Helper documentation for an explanation what the
          * callback is good for.
          */
        bool parseConfiguration(Glib::ustring tag, XML_Helper* helper);

        static Glib::ustring s_filename;
};

#endif // CONFIGURATION_H
