// Copyright (C) 2011, 2014 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef ARMY_BASE_H
#define ARMY_BASE_H

#include <gtkmm.h>


class XML_Helper;

class ArmyBase
{
    public:

	//! Copy constructor.
        ArmyBase(const ArmyBase& army);

	//! Loading constructor.
        ArmyBase(XML_Helper* helper);
        
	//! Create an empty army base.
	ArmyBase();

	//! Destructor.
        virtual ~ArmyBase();

    protected:

        //! Generic method for saving Army base data.
        bool saveData(XML_Helper* helper) const;


    private:
};

#endif // ARMY_BASE_H
