// Copyright (C) 2011, 2014 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef ARMY_PROTO_H
#define ARMY_PROTO_H

#include <gtkmm.h>
#include "PixMask.h"
#include "shield.h"
#include "armyprotobase.h"

class XML_Helper;
class Armyset;
class Tar_Helper;

class ArmyProto : public ArmyProtoBase
{
    public:
	//! The xml tag of this object in an armyset configuration file.
	static Glib::ustring d_tag; 

	//! Copy constructor.
        ArmyProto(const ArmyProto& armyproto);

	//! Loading constructor.
        ArmyProto(XML_Helper* helper);
        
	//! Default constructor.  Create an empty army prototype.
	ArmyProto();

	//! Destructor.
        virtual ~ArmyProto();


        // Set Methods
        
        //! Set the basic image of the Army.
        void setImage(Shield::Colour c, PixMask* image) {d_image[c] = image;};


        // Get Methods
        
	//! Returns the basename of the picture's filename
	/**
	 * Returns the filename that holds the image for this Army.
	 * The filename does not have a path, and the filename does
	 * not have an extension (e.g. .png).
	 */
	Glib::ustring getImageName(Shield::Colour c) const {return d_image_name[c];}

        //! Get the image of the army prototype. 
	PixMask* getImage(Shield::Colour c) const {return d_image[c];};

	// Methods that operate on class data and modify the class.

	//! Load the pictures associated with this ArmyProto object.
	void instantiateImages(guint32 tilesize, Tar_Helper *t, bool &broken);

	//! Load the ArmyProto image in the given filename.
	void instantiateImages(int tilesize, Shield::Colour c, Glib::ustring image_filename, bool &broken);

	//! Destroy the images associated with this ArmyProto object.
	void uninstantiateImages();

	// Methods that operate on class data and do not modify the class.

        //! Saves the Army prototype to an opened armyset file.
        virtual bool save(XML_Helper* helper) const;
        
    protected:

	//! Callback to read this object from an opened file.
	bool saveData(XML_Helper* helper) const;

    private:

	//! The picture of the Army prototype.
	/**
	 * There is an image for each player, plus the neutral player.
	 */
	PixMask* d_image[MAX_PLAYERS + 1];

	//! The basename of the file containing the image for this Army proto.
	/**
	 * This value does not contain a path, and does not contain an
	 * extension (e.g. .png).
	 *
	 * There is an image filename for each player, plus the neutral player.
	 */
	Glib::ustring d_image_name[MAX_PLAYERS + 1];
};

#endif // ARMY_PROTO_H
