// Copyright (C) 2011, 2014 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef ARMY_PROTO_BASE_H
#define ARMY_PROTO_BASE_H

#include <gtkmm.h>

#include "defs.h"

class XML_Helper;

#include "armybase.h"

class ArmyProtoBase : public ArmyBase
{
    public:

	//! Copy constructor.
        ArmyProtoBase(const ArmyProtoBase& armyprotobase);

	//! Loading constructor.
        ArmyProtoBase(XML_Helper* helper);
        
	//! Default constructor.  Create an empty army prototype base.
	ArmyProtoBase();

	//! Destructor.
        ~ArmyProtoBase();

        // Set Methods
        
        void setTypeId(guint32 type_id) {d_type_id = type_id;};

	//! Sets the armyset id for this army.
	void setArmyset(guint32 id) {d_armyset = id;};

        // Get Methods
        
	//! Get the Id of the Armyset to which the Army's type belongs.
        guint32 getTypeId() const {return d_type_id;}

        //! Returns the descriptive text of this Army.
        Glib::ustring getDescription() const {return d_description.c_str();}

	//! Returns the armyset id for this army.
	guint32 getArmyset() const {return d_armyset;};

        //! Returns the name of the Army.
        Glib::ustring getName() const {return d_name.c_str();};

        double getMoveBonus() const {return d_move_bonus;}
        gint32 getMaximumMoves() const {return d_max_moves;}
        guint32 getAttackBonus() const {return d_attack_bonus;}
        double getPowerBonus() const {return d_power_bonus;}

        bool canAttackAcrossWater() const {return d_can_attack_across_water;}
        double getAttackBonusWaterPenalty() const {return d_attack_bonus_water_penalty;}
        bool canMoveAcrossWater() const {return d_can_move_across_water;}
        bool canAttackOverEnemies() const {return d_can_attack_over_enemies;}
        bool canDestroyBrick() const {return d_can_destroy_brick;}
        guint32 getMinimumDieToBreakBrick() const {return d_minimum_die_to_break_brick;}
        bool isWinningPiece() const {return d_winning_piece;}

    protected:
	//! Callback method for loading this object from an opened file.
	bool saveData(XML_Helper* helper) const;

	//! The name of the Army unit.  e.g. Scouts.
        Glib::ustring d_name;

	//! The index of the Army prototype's index in it's Armyset.
        guint32 d_type_id;

	//! The description of the Army unit.
        Glib::ustring d_description;

	//! The armyset to which this army prototype belongs.
	guint32 d_armyset;

        double d_move_bonus;
        gint32 d_max_moves;
        guint32 d_attack_bonus; //the box
        double d_power_bonus; //the die value modifier
	
        bool d_can_attack_across_water;
        double d_attack_bonus_water_penalty;
        bool d_can_move_across_water;
        bool d_can_attack_over_enemies;
        bool d_can_destroy_brick;
        guint32 d_minimum_die_to_break_brick;
        bool d_winning_piece;
};

#endif // ARMY_PROTO_BASE_H
