//  Copyright (C) 2011, 2014 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef GAME_PARAMETERS_H
#define GAME_PARAMETERS_H

#include <vector>
#include "player.h"

class GameParameters
{
public:
    struct Player 
    {
	enum Type { HUMAN, OFF};

	Type type;
	Glib::ustring name;
	guint32 id;
    };

    std::vector<Player> players;

    Glib::ustring name;
    // path to map file to load, empty if none
    Glib::ustring map_path;

  static GameParameters::Player::Type player_type_to_player_param(guint32 type)
    {
      if (type == 0) //Player::HUMAN
        return GameParameters::Player::HUMAN;
      return GameParameters::Player::OFF;
    }
  static guint32 player_param_to_player_type(guint32 param)
    {
      if (param == GameParameters::Player::HUMAN)
        return 0;
      else if (param == GameParameters::Player::OFF)
        return 0; //no equiv.
    }
  static GameParameters::Player::Type player_param_string_to_player_param(Glib::ustring s)
    {
      if (s == HUMAN_PLAYER_TYPE)
        return GameParameters::Player::HUMAN;
      else
        return GameParameters::Player::HUMAN;
    }
  static Glib::ustring player_param_to_string (guint32 type)
    {
      switch (type)
        {
        case GameParameters::Player::HUMAN: return HUMAN_PLAYER_TYPE;
        case GameParameters::Player::OFF: return NO_PLAYER_TYPE;
        default: return NO_PLAYER_TYPE;
        }
    }
};

#endif
