//  Copyright (C) 2011, 2014 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef DICEBOX_H
#define DICEBOX_H

#include <gtkmm.h>
#include <sigc++/signal.h>
#include <vector>
class DiceBox
{
 public:
     enum Mode 
       {
         NONE,
         MOVE,
         ATTACK,
     };

    DiceBox();
    ~DiceBox();
    Gtk::Widget *get_widget() {return contents;}

    void shuffle_dice(int val1, int val2, int val3, int val4);
    void clear_selected_die();
    sigc::signal<void, int> die_selected_for_move;
    sigc::signal<void, int> die_selected_for_attack;
    sigc::signal<void, int> die_selected;
    sigc::signal<void> no_dice;
    sigc::signal<void> more_dice;
    void set_sensitive(bool sens) {contents->set_sensitive(sens);};
    Mode get_mode();
    void roll_defender_die(int land_on);
    void clear_all_dice();
    void load(std::vector<guint32> dice, int selected_die_value);
 protected:

 private:
    Gtk::Box *contents;
    Gtk::Button *die1_button;
    Gtk::Button *die2_button;
    Gtk::Button *die3_button;
    Gtk::Button *die4_button;
    Gtk::Button *selected_die_button;
    Gtk::Image *die1_image;
    Gtk::Image *die2_image;
    Gtk::Image *die3_image;
    Gtk::Image *die4_image;
    Gtk::Image *selected_die_image;
    Gtk::ToggleButton *attack_button;
    Gtk::ToggleButton *move_button;

    //callbacks
    void on_move_toggled();
    void on_attack_toggled();
    void on_die_selected(Gtk::Button *die_button);

    //helpers
    void shuffle_die(int die, int land_on);
    bool no_more_dice_to_select() {return (die1_selected && die2_selected && die3_selected && die4_selected);};

    int selected_die;
    bool die1_selected;
    bool die2_selected;
    bool die3_selected;
    bool die4_selected;
};

#endif // DICEBOX_H
