//  Copyright (C) 2011, 2014 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include <sigc++/functors/mem_fun.h>

#include "reinforcement-point-list.h"
#include "reinforcement-point.h"
#include "GameMap.h"
#include "xmlhelper.h"

Glib::ustring ReinforcementPointlist::d_tag = "reinforcementpointlist";
//#define debug(x) {cerr<<__FILE__<<": "<<__LINE__<<": "<<x<<endl<<flush;}
#define debug(x)

ReinforcementPointlist* ReinforcementPointlist::s_instance=0;

ReinforcementPointlist* ReinforcementPointlist::getInstance()
{
    if (s_instance == 0)
        s_instance = new ReinforcementPointlist();

    return s_instance;
}

ReinforcementPointlist* ReinforcementPointlist::getInstance(XML_Helper* helper)
{
    if (s_instance)
        deleteInstance();

    s_instance = new ReinforcementPointlist(helper);
    return s_instance;
}

void ReinforcementPointlist::deleteInstance()
{
    if (s_instance)
        delete s_instance;

    s_instance = 0;
}

ReinforcementPointlist::ReinforcementPointlist()
{
}

ReinforcementPointlist::ReinforcementPointlist(XML_Helper* helper)
{
    helper->registerTag(ReinforcementPoint::d_tag, sigc::mem_fun(this, &ReinforcementPointlist::load));
}

bool ReinforcementPointlist::save(XML_Helper* helper) const
{
    bool retval = true;

    retval &= helper->openTag(ReinforcementPointlist::d_tag);

    for (const_iterator it = begin(); it != end(); it++)
        retval &= (*it)->save(helper);
    
    retval &= helper->closeTag();

    return retval;
}

bool ReinforcementPointlist::load(Glib::ustring tag, XML_Helper* helper)
{
    if (tag != ReinforcementPoint::d_tag)
    //what has happened?
        return false;
    
    push_back(new ReinforcementPoint(helper));

    return true;
}
