//  Copyright (C) 2011, 2014 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef SHIELD_H
#define SHIELD_H

#include <gtkmm.h>
#include <sigc++/trackable.h>
#include <sigc++/signal.h>

class Shield : public sigc::trackable
{
    public:

	//! The notional player that the Shield goes with.
	enum Colour {BLUE = 0, RED = 1 };

	static Gdk::Color get_default_color_for_no(int player_no);

	//! Convert the Shield::Colour enumerated value to a string.
	static std::string colourToString(const Shield::Colour c);

    protected:

};

#endif // SHIELD_H
