// Copyright (C) 2011, 2014 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef SOUNDSET_H
#define SOUNDSET_H

#include "xmlhelper.h"

#include <map>
#include <vector>
#include <sigc++/trackable.h>

struct MusicItem
{
    // The file where the sound piece can be loaded from
    Glib::ustring file;
    // Can it be played in the background?
    bool background;
    // If loading this file fails, we can define an alias to load instead.
    Glib::ustring alias;
};


class Soundset : public sigc::trackable
{
    public:
        Soundset(XML_Helper *helper);
        Soundset();
        ~Soundset();

        std::map<Glib::ustring, MusicItem*> getPieces() const {return d_musicMap;}
        Glib::ustring getPieceFilename(Glib::ustring piecename) const;
        void setPieces(std::map<Glib::ustring, MusicItem*> map);

        bool save(XML_Helper* helper) const;

        void getFilenames(std::list<Glib::ustring> &files) const;
    private:

        //! Callback for the music data, see XML_Helper 
        bool loadMusic(Glib::ustring tag, XML_Helper* helper);

	// DATA
        
        // music is stored here, access by d_musicMap[name]
        std::map<Glib::ustring, MusicItem*> d_musicMap;
};

#endif //SOUNDSET_H
