<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "event";
include_once ("config/evt.config.php");
include_once ('inc/evt_initiate.inc.php');
// get locations
$output_locations = $user->selLocations($_SESSION['language_id']);
$body->set('locations', $output_locations);
$body->set('datedropdown', $date->dateDropdown());


if (isset($_REQUEST['event_id'])) {

	$output_event['event_start_date'] = date('Y-m-d', strtotime($output_event['event_end_datetime'] . " - " . $output_event['event_duration'] . " hours"));
	$output_event['event_start_time'] =  date('H:i', strtotime($output_event['event_end_datetime'] . " - " . $output_event['event_duration'] . " hours"));
	$output_event['event_duration_type'] = $output_event['event_duration'] >= 24 ? 24 : 1;
	
	if ($output_event['event_duration'] >= 24) {
		$output_event['event_duration'] = round($output_event['event_duration'] / 24);
	}

	if (!isset($output_event) || empty($output_event)) {
		header("location: index.php?amn=evt_item&event_id=" . $evt->event_id);
		exit;
	}
}

if (isset($_POST['sub_insert'])) {
	
	if (isset($_POST['event_all_day'])) {
		$_POST['event_duration'] = 24;
		$_POST['event_duration_type'] = 1;
	}
	
	if (isset($_REQUEST['event_id'])) {
		$event->updateEvent($_POST);
	}
	else {
		$event->insertEvent($_POST);
		
		if (empty($GLOBALS['am_error_log'])) {
			require_once ('components/core/class/Participation.class.php');
			$participation = new Participation($db, $core_config);
			$participation->module_id = $core_config['module_id']['event'];
			$participation->item_id = $event->event_id;
		
			$user->identity_type = $core_config['user']['identity']['type']['registered'];
			$output_identity = $user->selUserIdentity($_SESSION['user_id']);
		
			$permission = 0;
			foreach($event_config['resource']['user'] as $e) {
				$permission += $e;
			}
			
			$data = array();
			$data['role_id'] = $event_config['role']['coordinator'];
			$data['user_id'] = $_SESSION['user_id'];
			$data['status_id'] = $event_config['user']['status']['active'];
			$data['identity_id'] = $output_identity['identity_id'];
			$data['participation_permission'] = $permission;
		
			$participation->insertParticipant($data);
			
			
			// membership-type
			if ($_POST['participation_type'] == $event_config['type']['membership_type']) {
			
				$query = "
					DELETE FROM " . $db->prefix . "_mem_type_access 
					WHERE 
					module_id=" . $core_config['module_id']['event'] . " AND 
					item_id=" . $event->event_id
				;
			
				if (!empty($_POST['membership_types'])) {
					foreach ($_POST['membership_types'] as $key => $i) :
						$rec = array();
						$rec['module_id'] = $core_config['module_id']['event'];
						$rec['item_id'] = $event->event_id;
						$rec['membership_type_id'] = $i;
						
						$table = $db->prefix . "_mem_type_access";
							
						$query = $db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
						$result = $db->Execute($query);
					endforeach;
				}
			}
			
			// Count events -----------------------------------
			$query = "
				SELECT COUNT(*) AS total_events
				FROM " . $db->prefix . "_event"
			;
			
			$result = $db->Execute($query);
			if (isset($result->fields)) {
				$total_events = $result->fields['total_events'];
				$result->Close();
			}
			else {
				$error_info = "file=evt_edit.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array('db_error', $error_info);
			}
			
			// insert statistics ------------------------------
			require_once('components/core/class/Statistic.class.php');
			$statistic = new Statistic($db, $event_config['statistic']);
			$statistic->module_id = $core_config['module_id']['event'];
			$statistic->item_id = $_SESSION['user_id'];
		
			// insert event statistics
			$statistic->statistic_type_id = $event_config['statistic']['total_events'];
			$statistic->setStatistic($total_events);
		}
	}
	
	if (empty($GLOBALS['am_error_log'])) { // everything was ok, send us to next page
	
		header("location: index.php?amn=evt_manage&event_id=" . $event->event_id);
		exit;
	}
	
	$output_event = $_POST;
	$output_event['event_start_date'] = $_POST['schedule_start_date'];
	$output_event['event_start_time'] = $_POST['schedule_start_time'];
	$output_event['event_body']       = stripslashes($output_event['event_body']);
	$output_event['membership_type_ids'] = $_POST['membership_types'];
}
elseif (isset($_POST['sub_preview'])) {
	
	$output_event = $_POST;
	$output_event['event_start_date'] = $_POST['schedule_start_date'];
	$output_event['event_start_time'] = $_POST['schedule_start_time'];
	$output_event['event_body']       = $wiki->transform(stripslashes($output_event['event_body']), 'Xhtml');
	
	
	$output_event['membership_type_ids'] = $_POST['membership_types'];
	$body->set('event_preview', $output_event);
}
else {
	$output_event['location_id'] = $_SESSION['location_id']; // pre-define location
}

// if (!empty($output_event)) {
// 	if ($_SESSION['user_id'] == $output_event['user_id']) {
// 			// obtain any roles
// 			$query = "
// 				SELECT * 
// 				FROM " . $db->prefix . "_mem_type_access 
// 				WHERE 
// 				module_id=" . $core_config['module_id']['library'] . " AND 
// 				item_id=" . $output_set['set_id']
// 			;
// 		
// 			$result = $db->Execute($query);
// 		
// 			if (isset($result->fields)) {
// 				$membership_type_ids = array();
// 
// 				while (!$result->EOF) {
// 					array_push($membership_type_ids, $result->fields);
// 					$result->MoveNext();
// 				}
// 				
// 				$output_event['membership_type_ids'] = $membership_type_ids;
// 			}
// 	}
// }



// FILE SETUP
require_once ("components/core/class/File.class.php");
$file = new File($db, $core_config['file']);
$file->user_id = $_SESSION['user_id'];
$file->module_id = 0; // core
$file->directory = "core";
$file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
$file->thumbs = $core_config['file']['image']['thumb'];

$images = $file->selFiles("images", "t2");
$body->set("images", $images);


$body->set('event_config', $event_config);
$body->set('event', $output_event);

?>
