<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


$menu_section= "library";


$body->set('set', $output_set);

// FILE -----------------------------------
require_once ("components/core/class/File.class.php");
$file = new File($db, $core_config['file']);
$file->module_id = 0; // core
$file->directory = "core";
$file->thumb = $core_config['file']['image']['thumb'][0]['suffix'];
$file->no_image = $core_config['file']['image']['thumb'][0]['no_image'];
$user->file = $file;


// get identity of person I am looking at
$output_identity_relation = $user->selUserIdentity(null, $_REQUEST['identity_id'], 1);

if (empty($output_identity_relation)) {
	header("Location: index.php?" . strip_tags(SID));
	exit;
}


// get my identity
if (!empty($output_participation)) {
	$output_identity = $user->selUserIdentity(null, $output_participation['identity_id'], 1);
}
else { // we are not participating in this item/module hence we get my registered card
	$user->identity_type = $core_config['user']['identity']['type']['registered'];
	$output_identity = $user->selUserIdentity($_SESSION['user_id'], null, 1);
}


// GET FAVOURITES --------------------------------------------------------
require_once('components/core/class/Bookmark.class.php');
$bookmark = new Bookmark($db, $core_config['module_id']['library']);

// get my bookmarked favourites
$bookmark->bookmark_type = $core_config['bookmark']['type']['recommend'];
$output_bookmarks = $bookmark->selBookmarks(1);

if (!empty($output_bookmarks)) {
	// we get item_id's and we get the sets from that
	foreach ($output_bookmarks as $key => $i):
		$library->page_ids[] = $i['inner_item_id'];
	endforeach;
	
	unset ($library->file);
	
	if (!empty($library->page_ids)) {
		$output_bookmarks = $library->selPages(null, 1);
	}
	
	$body->set('recommendations', $output_bookmarks);
}


// GET AND SET TAGS ---------------------------------------------
require_once('components/core/class/Tag.class.php');
$tag = new Tag($db, null, $core_config['tag']['core']['network']);
$tag->user_id = $_SESSION['user_id'];
$tag->item_id = $output_identity_relation['user_id'];

if (isset($_POST['insert_tag'])) {
	if (empty($_POST['tag_id'])) { // we insert
		$tag->insertTag($_POST['tag_body']);
	}
	elseif (!empty($_POST['tag_id']) && empty($_POST['tag_body'])) { // we delete
		$tag->deleteTag($_POST['tag_id']);
	}
	else { // we update tag
		$tag->updateTag($_POST['tag_id'], $_POST['tag_body']);
	}
}
elseif (isset($_POST['delete_tag'])) {
	$tag->deleteTag($_POST['tag_id']);
}
elseif (isset($_REQUEST['edit_tag'])) {
	$output_tag = $tag->selTag($_REQUEST['edit_tag']);

	if (!empty($output_tag)) {
		$body->set('tag', $output_tag);
	}
}

$output_tags = $tag->selTags();

if (!empty($output_tags)) {
	$body->set('tags', $output_tags);
}


// GET USER STATISTICS ---------------------------------------------------
require_once('components/core/class/Statistic.class.php');
$statistic = new Statistic($db, $library_config['statistic']);
$statistic->module_id = $core_config['module_id']['library'];
$statistic->item_id = $output_set['set_id'];

$output_statistics['library'] = $statistic->selStatistics();

if (!empty($output_statistics)) {
	$body->set('statistics', $output_statistics);
}


// WIKI SETS ------------------------------------------------
// get the wiki sets that I am contributing to
unset($participation->item_id);
$output_set_participation = $participation->selParticipants(null, null, $output_identity_relation['user_id']);

if (!empty($output_set_participation)) {
	// get participants for each item
	foreach($output_set_participation as $key => $i):
		$library->set_ids[] = $i['item_id'];
	endforeach;
	
	$library->file = $file;
	$library->file->thumb = $core_config['file']['image']['thumb'][2]['suffix'];
	$library->file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
	

	$output_user_sets = $library->selSets();
	
	if (!empty($output_user_sets)) {
		$body->set('user_sets', $output_user_sets);
	}		
}

// SETUP WIKI ------------------------------------------------------------
require_once('components/core/class/Wiki/Wiki.php');
require_once ('components/core/class/Wiki/Wiki/Parse.php');
require_once ('components/core/class/Wiki/Wiki/Render.php');
$wiki = new Text_Wiki();


// GET LATEST COMMENTS --------------------------------------------------------
require_once('components/core/class/Comment.class.php');
$comment = new Comment($db, $core_config['module_id']['library']);
$comment->wiki = $wiki;
$comment->module_id = $core_config['module_id']['library'];
$comment->item_id = $output_set['set_id'];
$comment->user_id = $output_identity_relation['user_id'];
$comment->limit = 4;
$comment->order_by = "c.comment_create_datetime desc";

$output_comments = $comment->selComments();

if (!empty($output_comments)) {
	$body->set('latest_comments', $output_comments);
}


// GET LATEST REVISIONS -------------------------------------------
$library->limit = 16;
$library->user_id = $output_identity_relation['user_id'];

$output_revisions = $library->selRevisions(null, 1);

if (!empty($output_revisions)) {
	$body->set('revisions', $output_revisions);
}




// Setup Tie -------------------------------------------------------------
require_once ("components/core/class/Tie.class.php");
$tie = new Tie($db, $core_config);
$tie->count_weak = true;
$tie->count_strong = true;
$output_ties['strong'] = $tie->selStrongTiePaths($output_identity['identity_id'], $output_identity_relation['identity_id'], 'outbound', 3);
$output_ties['strong_weak'] = $tie->selStrongToWeakTiePaths($output_identity['identity_id'], $output_identity_relation['identity_id'], 3);
$output_ties['weak_strong'] = $tie->selWeakToStrongTiePaths($output_identity['identity_id'], $output_identity_relation['identity_id'], 3);
$output_ties['weak_outbound'] = $tie->selWeakTiePaths($output_identity['identity_id'], $output_identity_relation['identity_id'], 'outbound', 3);
$output_ties['weak_inbound'] = $tie->selWeakTiePaths($output_identity['identity_id'], $output_identity_relation['identity_id'], 'inbound', 3);

$output_ties_common = $tie->selCommonTies($output_identity['identity_id'], $output_identity_relation['identity_id']);


if (!empty($output_ties)) {
	$body->set('ties', $output_ties);
}

if (!empty($output_ties_common)) {
	$body->set('ties_common', $output_ties_common);
}

if (isset($output_common_ties)) {
	$body->set('common_ties', $output_common_ties);
}


require_once ("components/core/class/Testimonial.class.php");
$testimonial = new Testimonial($db);
$testimonial->identity_id = $output_identity_relation['identity_id'];
$testimonial->testifier_identity_id = $output_identity['identity_id'];

$output_testimonials = $testimonial->selTestimonials(true, 2, true);

if (isset($output_testimonials)) {
	$body->set('testimonials', $output_testimonials);
}


$body->set('identity', $output_identity_relation);





// GET THE INVITEE
if (!empty($output_identity_relation['invitee_user_id'])) {
	
	$file->thumb = $core_config['file']['image']['thumb'][0]['suffix'];
	$file->no_image = $core_config['file']['image']['thumb'][0]['no_image'];
	
	$output_invitee_identity = $user->selUserIdentity($output_identity_relation['invitee_user_id']);
	
	// get the invitee testimonial
	if (!empty($output_invitee_identity)) {
		$testimonial->user_id = $output_invitee_identity['user_id'];
		$output_testimonial = $testimonial->selTestimonials(false, 1);
		
		if (!empty($output_testimonial[0])) {
			$output_invitee_identity['testimonial'] = $output_testimonial[0];
		}
		
		$body->set('invitee_identity', $output_invitee_identity);
	}
}



// get metadata
$query = "
	SELECT 
	user_metadata 
	FROM 
	" . $db->prefix . "_user u, " . $db->prefix . "_user_preference up 
	WHERE 
	u.user_id=up.user_id AND 
	up.user_preference_id=" . $core_config['user']['preference']['allow_sn_search'] . " AND 
	u.user_id=" . $output_identity_relation['user_id']
;
			
$result = $db->Execute($query);
			
if (isset($result->fields)) {
	if (!empty($result->fields['user_metadata'])) {
		$user_metadata = explode(',', $result->fields['user_metadata']);
		sort($user_metadata);
		$body->set('user_metadata', $user_metadata);
	}
}


// blocked ---------------------------------------
$user->user_id = $_SESSION['user_id'];

if ($user->checkBlockStatus($output_identity_relation['user_id'])) {
	$body->set('blocked', $output_blocked);
}


include_once ($language_path . "/inc/profile.lang.inc.php");

?>
