<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------


include "config/config.inc.php";
include $c_node['dir']['aroundme'] . "config/config_aroundme.inc.php";
include $c_node['dir']['aroundme'] . "inc/functions.inc.php";



//SETUP TEMPLATE
$templatePath = $c_node['dir']['template_path'];

require_once($c_node['dir']['aroundme'] . $c_node['dir']['class_path'] . '/Template.class.php');

$tpl = & new Template($templatePath); // This is the outter template
$tpl->set('templatePath', $templatePath);

$body = & new Template($templatePath); // This is the inner template
$body->set('templatePath', $templatePath);


//SETUP LANGUAGE
session_start();
if(isset($_REQUEST['language_id'])) {
	$language_id = $_REQUEST['language_id'];
	$_SESSION['s_language_id'] = $language_id;
}
elseif (isset($_SESSION['s_language_id']) && $_SESSION['s_language_id'] > 0){
    $language_id = $_SESSION['s_language_id'];
}
else {
	$language_id = $c_node['node']['language_default'];
	$_SESSION['s_language_id'] = $language_id;
}


//include error handling files from aroundme
$languagePath = $c_node['dir']['aroundme'] . "language/" . $language_id . "/" . $c_node['node']['template_default_name'];
$languageArrayPath = $languagePath . "/arrays/";
$languageTextPath = $languagePath . "/texts/";
require_once($languageArrayPath . 'arr_language_name.lang.php');
require_once($languageArrayPath . 'arr_error.lang.php');


//SETUP FILE AND PAGE VARS
$current_filename = basename($_SERVER['PHP_SELF']);
$page_name = explode(".",$current_filename);

//RETRIEVE LANGUAGE FILE AND PASS TO TEMPLATE
$languagePath = "language/" . $language_id . "/";
require_once($languagePath . $page_name[0] . '.lang.php');


//database setup and connect
require_once($c_node['dir']['aroundme'] . $c_node['dir']['class_path'] . 'Adodb/adodb.inc.php');
$ADODB_CACHE_DIR = 'cache/Adodb';
$ADODB_FETCH_MODE = ADODB_FETCH_BOTH;
$db = NewADOConnection('mysql');
$db->Connect($c_node['db']['host'], $c_node['db']['user'] , $c_node['db']['pass'] , $c_node['db']['db']);
$db->prefix = $c_node['db']['prefix'];


//Date
require_once($c_node['dir']['aroundme'] . $c_node['dir']['class_path'] . 'Date.class.php');
$date = new Date();

?>
