<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

/*
* Trim
* tom calthrop
* 10th Jan 2004
*/
function dots($num, $string) {
	if (strlen($string) > $num) {
		$string = substr_replace($string, '...', $num);
	}
	return $string;
}


/*
* Read file from hard disk and return
* tom calthrop
* 22nd April 2004
*/
function readTxtFile($source) {

	$handle = fopen($source, "rb");
	$output = "";
	do {
	   $data = fread($handle, 8192);
	   if (strlen($data) == 0) {
	       break;
	   }
	   $output .= $data;
	} while (true);

	fclose($handle);

	$output = addslashes($output);
	//$output = str_replace("\\\"", "\"", $output);
	//$output = str_replace("'", "´", $output);

	return $output;
}




/*
* searchTextFormat
* takes a search string, highlights it in the supplied txt
* and strips unwanted data
*
* tom calthrop
* 10th April 2004
*/
function searchTextFormat($search, $txt) {

	//remove all html
	$pattern = array ("'<script[^>]*?>.*?</script>'si",  // Strip out javascript
		"'<[\/\!]*?[^<>]*?>'si",          // Strip out HTML tags
       	"'([\r\n])[\s]+'",                // Strip out white space
       	"'&(quot|#34);'i"                // Replace HTML entities
	);

	$replace = array ("",
       	"",
       	"\\1",
		"\""
	);

	$txt = preg_replace($pattern, $replace, $txt);

	//show 20 chars before first highlighted word
	$search_start_pos = (strlen($txt) - strlen(stristr($txt,$search))-20);

	if ($search_start_pos > 20) {
		$txt = substr($txt,$search_start_pos);
		$txt = "..." . $txt;
	}

	//reduce string length to 150 char
	if (strlen($txt) > 150) {
		$txt = substr($txt,0, 160);
		$txt = $txt . "...";
	}

	//make the search word red
	$txt = preg_replace("/($search)/i","<span class='txt_red'><b>\\0</b></span>",$txt);

	return $txt;
}



/*
* setHomepage
* Tom Calthrop 11th April 2004
*/
function setHomepage ($pagename) {

	global $db, $me, $error;

	$query = "
		UPDATE br_user
		SET user_homepage='" . $pagename . "'
		WHERE user_id=" . $me['user_id']
	;

	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else {
		$_SESSION['s_homepage'] = $pagename;
		$me['homepage'] = $pagename;
	}
}

?>
