<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "my";
include "inc/header.inc.php";

require_once($c_node['class_dir'] . 'Poll.class.php');


if (isset($_REQUEST['poll_id'])) {
	$poll_id = $_REQUEST['poll_id'];
}


//event
$poll = new Poll();
$poll->db = $db;
$poll->date = $date;
$poll->user_id = $me['user_id'];
if (isset($poll_id)) {
    $poll->poll_id = $poll_id;
}



if (isset($_REQUEST['view_poll'])) {
	$output_poll = $poll->getPoll();
	$display = "view_poll";

}
elseif (isset($_POST['edit_poll'])) {
	$output_poll = $poll->getPoll();

	$display = "edit_poll";

}
elseif (isset($_REQUEST['add_poll'])) {

	$display = "add_poll";

}
elseif (isset($_POST['insert_poll'])) {
	$insert = $poll->insertPoll($data);

	if ($insert[0][0] == "success") {
	    $success = $insert;
	}
	else {
	    $error = $insert;
	}

	$output_polls = $poll->getPolls();

	$display = "list_polls";

}
elseif (isset($_POST['update_poll'])) {
	$update = $poll->updatePoll($data);

	if ($update[0][0] == "success") {
	    $success = $update;
		$output_poll = $poll->getPoll();

		$display = "view_poll";
	}
	else {
	    $error = $update;
		$output_poll = $data;
		$display = "edit_poll";
	}

}
elseif (isset($_POST['delete_poll'])) {
	$delete = $poll->deletePoll();

	if ($delete[0][0] == "success") {
	    $success = $delete;
	}
	else {
	    $error = $delete;
	}

	$output_polls = $poll->getPolls();

	$display = "list_polls";

}
elseif (isset($_POST['insert_poll_option'])) {
	$insert = $poll->insertOption($data['option_body']);

	if ($insert[0][0] == "success") {
	    $success = $insert;
	}
	else {
	    $error = $insert;
	}

	$output_poll = $poll->getPoll();

	$display = "view_poll";
}
elseif (isset($_POST['update_poll_option'])) {
	$update = $poll->updateOption($data['option_id'], $data['option_body']);

	if ($update[0][0] == "success") {
	    $success = $update;
	}
	else {
	    $error = $update;
	}

	$output_poll = $poll->getPoll();

	$display = "view_poll";

}
elseif (isset($_POST['delete_poll_option'])) {
	$delete = $poll->deleteOption($data['option_id']);

	if ($delete[0][0] == "success") {
	    $success = $delete;
	}
	else {
	    $error = $delete;
	}

	$output_poll = $poll->getPoll();

	$display = "view_poll";

}
else {
	//list event
	$output_polls = $poll->getPolls();

	$display = "list_polls";

}


//work out if we are allowed to delete or edit this poll
if ($display == "view_poll") {
	$output_poll_usage = $poll->getPollUsage();

	// you cannot edit a poll that is past it's start date and has votes.
	$datetime = date("Y-m-d H:i:s");

	if (($output_poll['poll_start_datetime'] <= $datetime) && ($output_poll['total_votes'] < 1)) {
	    $allow_edit = true;
	}

	//You cannot delete a poll if it is being used
	if (count($output_poll_usage) < 1) {
	    $allow_delete = true;
	}

	if (isset($_REQUEST['option_id'])) {
		//we edit an option
		$output_option = $_REQUEST['option_id'];
	}

	if (isset($output_poll)) {
		$output_poll_history = $poll->pollUserVoteHistory($me['user_id']);
	}
}


//move to template
if (isset($output_group_member_level)) {
	$body->set('group_member_level', $output_group_member_level);
}

if (isset($output_group)) {
	$body->set('group', $output_group);
}

if (isset($display)) {
	$body->set('display', $display);
}

if (isset($output_polls)) {
   $body->set('polls', $output_polls);
}

if (isset($output_poll)) {
   $body->set('poll', $output_poll);
}

if (isset($output_poll_usage)) {
   $body->set('poll_usage', $output_poll_usage);
}

if (isset($allow_edit)) {
   $body->set('allow_edit', $allow_edit);
}

if (isset($allow_delete)) {
   $body->set('allow_delete', $allow_delete);
}

if (isset($output_option)) {
   $body->set('option', $output_option);
}

if (isset($output_poll_history)) {
	$body->set('poll_history', $output_poll_history);
}

if (isset($output_poll['event_start_datetime'])) {
   $body->set('start_datedropdown', $date->dateDropdown($output_poll['poll_start_datetime'], 1, 'start'));
}
else {
   $body->set('start_datedropdown', $date->dateDropdown(date("Y-m-d H:00:00"), 1, 'start'));
}

if (isset($output_poll['event_end_datetime'])) {
   $body->set('end_datedropdown', $date->dateDropdown($output_poll['poll_end_datetime'], 1, 'end'));
}
else {
   $body->set('end_datedropdown', $date->dateDropdown(date("Y-m-d H:00:00"), 1, 'end'));
}

include "inc/footer.inc.php";

?>
