<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "user";
include "inc/header.inc.php";

//check user is node_admin
if ($output_user['level_id'] < $c_node['user_level_id']['node_administrator']) {
    header("Location: " . $_SESSION['s_homepage'] . "?" . SID);
	exit;
}



//append language setup
require_once($languageArrayPath . 'arr_language_name.lang.php');
require_once($languageArrayPath . 'arr_user_priv.lang.php');
require_once($languageArrayPath . 'arr_group_type.lang.php');
require_once($languageArrayPath . 'arr_language_name.lang.php');
require_once($languageArrayPath . 'arr_genre.lang.php');
require_once($languageArrayPath . 'arr_group_status.lang.php');


//process requests
if (isset($_REQUEST['list_groups'])) {
	$output_groups = getGroups();
	$display = "list_groups";

}
elseif (isset($_REQUEST['list_users'])) {
	$output_users = getUsers();
	$display = "list_users";
}


//move to template
if (isset($output_users)) {
	$body->set('users', $output_users);
}

if (isset($output_groups)) {
	$body->set('groups', $output_groups);
}

if (isset($display)) {
	$body->set('display', $display);
}

$body->set('today', date("Y-m-d"));


include "inc/footer.inc.php";



/*
* getUsers
* Tom Calthrop 14th May 2004
*/
function getUsers() {

	global $db, $error, $date;

	$query = "
		SELECT u.user_firstname, u.user_surname ,  u.user_hometown, u.user_id,
		u.user_nic, u.language_id, u.level_id, u.user_create_datetime
		FROM " . $db->prefix . "_user u
		order by u.user_id"
	;

	$result = $db->Execute($query);

	if (!$result) {
	$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else {
		$temp = array();

		while (!$result->EOF) {
			$temp1 = $result->fields;
			$temp1['user_create_datetime'] = $date->formatDate($temp1['user_create_datetime']);

			array_push($temp, $temp1);
			$result->MoveNext();
		}

		$result->Close();
		return $temp;
	}
}//EO getUsers();




/*
* getGroups
* Tom Calthrop 14th May 2004
*/
function getGroups() {

	global $db, $log, $date;

	$query = "
		SELECT g.group_id, g.group_title, g.genre_id, g.group_status,
		g.level_id, g.group_create_datetime, g.group_type, g.group_election_date
		FROM " . $db->prefix . "_group g
		order by g.group_id"
	;

	$result = $db->Execute($query);

	if (!$result) {
	$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else {
		$temp = array();

		while (!$result->EOF) {
			$temp1 = $result->fields;
			$temp1['group_create_datetime'] = $date->formatDate($temp1['group_create_datetime']);

			$temp1['group_total_members'] = getGroupTotalMembers($temp1['group_id']);

			if ($temp1['group_status'] < 1) {
			    $temp1['group_status'] = 0;
			}

			array_push($temp, $temp1);
			$result->MoveNext();
		}

		$result->Close();
		return $temp;
	}
}//EO getGroups();



/*
* getGroupTotalMembers
* Tom Calthrop 14th May 2004
*/
function getGroupTotalMembers($group_id) {

	global $db, $log, $c_node;

	$query = "
		SELECT count(member_id) as total
		FROM " . $db->prefix . "_group_member
		WHERE
		group_id=" . $group_id . " and
		level_id >=" . $c_node['user_level_id']['member']
	;

	$result = $db->Execute($query);

	if (!$result) {
	$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else {
		$result->Close();

		if (isset($result->fields['total']) && $result->fields['total'] > 0) {
		    $total = $result->fields['total'];
		}
		else {
			$total = 0;
		}

		return $total;
	}
}//EO getGroupTotalMembers();
?>
