<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

class Socialnetwork {
	// Instance variables
	var $user_id;                        // User id
	var $db;                             // get db connect
	var $node_id;                        // Node id
	
	

	function Socialnetwork($user_id, $db, $node_id) {
		$this->user_id = $user_id;
		$this->db = $db;
		$this->node_id = $node_id;
	}



	function verifySocialNetwork ($user_id_friend) {
		//check that I (me) is allowed to see informnation about a user.

		$relationship = array();
		$relationship['type'] = 0;
		//now we compare

		if ($user_id_friend == $this->user_id) {
			//me
			$relationship['type'] = 3;


		} else {
			reset($this->sn_arr);
			$temp = array();
			foreach ($this->sn_arr as $key => $r) {
				if ($r['user_id'] == $user_id_friend && $r['node_id'] == $this->node_id) {
					//a friend
					$relationship['type'] = 2;
					break;
				}
				else if($r['acquaintance']) {

					foreach ($r['acquaintance'] as $key => $i) {
						if ($i['user_id'] == $user_id_friend && $i['node_id'] == $this->node_id) {
							//an acquaintance
							$relationship['type'] = 1;
							array_push($temp, $r);
							break;
						}
					}
				}
			}

			$relationship['path'] = $temp;
		}

		if ($relationship['type'] == 1) {
		    $relationship['path'] = $this->getSocialNetworkPath($relationship['path']);
		}

		return $relationship;
	}


	function getSocialNetworkPath($path) {
		$temp = array();

		foreach ($path as $key => $i) {

			$query = "
				SELECT u.user_id, u.user_firstname
				FROM " . $this->db->prefix . "_user u
				WHERE
				u.user_id =" . $i['user_id']
				;

	    	$result = $this->db->Execute($query);

			if (!$result) {
				$state[]  = array('error', 1, $this->db->ErrorMsg());
			}
			else {
				array_push($temp, $result->fields);
			}

		}
		$result->Close();
		return $temp;
	}



	/*
	* Get Newest Acquaintance
	* receives social network array and looks through it to get newest date
	* tom calthrop 25/03/2004
	*/
	function getNewestAcquaintance () {
		$newestDate = "0000-00-00 00:00:00";

		if (isset($this->sn_arr)) {
		foreach ($this->sn_arr as $key => $r) :

			if (!empty($r['acquaintance'])) {
			foreach ($r['acquaintance'] as $key => $i) :
				if ($newestDate <= $i['user_create_datetime']) {
				    $newestDate = $i['user_create_datetime'];
					$newest_user_id = $i['user_id'];
				}
			endforeach;
			}

		endforeach;
		}

		if (isset($newest_user_id)) {
		    return $newest_user_id;
		}
	}


	/*
	* getBlockStatus
	* tom calthrop 25/03/2004
	*/
	function getBlockStatus($user_id_friend) {

		$query = "
			SELECT user_id_blocked
			FROM " . $this->db->prefix . "_user_blocked
			WHERE
			user_id_blocker=" . $this->user_id . " and
			user_id_blocked=" . $user_id_friend
		;
		//echo $query;
	    $result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			$result->Close();

			if (isset($result->fields['user_id_blocked'])) {
			    return true;
			}

		}
	}//EO getBlockStatus();


	/*
	* blockUser
	* remove any connection with this user
	* tom calthrop 25/03/2004
	*/
	function blockUser($user_id_friend, $block_description) {

		$datetime = date("Y-m-d H:i:s");
		$datetime = $this->db->DBDate($datetime);

		$query = "
			INSERT INTO " . $this->db->prefix . "_user_blocked
			(user_id_blocker, user_id_blocked, block_description, block_datetime) values (
			" . $this->user_id . ",
			" . $user_id_friend . ",
			'" . $block_description . "',
			" . $datetime . "
			)"
		;

	    $result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			$result->Close();
		}


		//remove any relationship they have with me
		$query = "
			DELETE FROM " . $this->db->prefix . "_relation
			WHERE
			user_id=" . $user_id_friend . " and
			user_id_friend=" . $this->user_id
		;

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			$result->Close();
		}


		//remove any relationship I have with them
		$query = "
			DELETE FROM " . $this->db->prefix . "_relation
			WHERE
			user_id=" . $this->user_id . " and
			user_id_friend=" . $user_id_friend
		;

	    $result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			$result->Close();
		}

	} //EO blockUser();


	/*
	* blockUser
	* receives social network array and looks through it to get newest date
	* tom calthrop 25/03/2004
	*/
	function unblockUser($user_id_friend) {

		$query = "
			DELETE FROM " . $this->db->prefix . "_user_blocked
			WHERE
			user_id_blocker=" . $this->user_id . " and
			user_id_blocked=" . $user_id_friend
		;

	    $result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
		}

		$result->Close();

	} //EO blockUser();
	
	
	
	/*
	* getSocialNetwork
	* receives social network array - used te message compose friends lists
	* tom calthrop 25/03/2004
	*/
	function getSocialNetwork() {
	
		//get a string of all the user_id's in my social network
		$ids = "";
	
		foreach($_SESSION['s_social_network'] as $key => $i):
			if (isset($i['user_id']) && $i['user_id'] != $this->user_id) {
			    $ids .= $i['user_id'] . ",";
	
				foreach($i as $key => $r):
				if (isset($r['user_id']) && $r['user_id'] != $this->user_id) {
					$ids .= $r['user_id'] . ",";
				}
				endforeach;
			}
		endforeach;
	
		if (isset($ids)) {
		    //trim last comma
			$ids = substr($ids, 0, -1);
	
			//select user name from db
			$query = "
				SELECT DISTINCT u.user_firstname, u.user_surname, u.user_id
				FROM
				" . $this->db->prefix . "_user u
				WHERE
				u. user_id IN (" . $ids . ")
				ORDER BY u.user_firstname"
			;
			//echo $query;
			$result = $this->db->Execute($query);
	
			if (isset($result->fields)) {
				$temp = array();
	
				while (!$result->EOF) {
	
					$temp1 = $result->fields;
	
					array_push($temp, $temp1);
	
					$result->MoveNext();
				}
	
				return $temp;
			}
			else {
				$this->log[]  = array('error', 1, $query . "-" . $this->db->ErrorMsg(), null);
			}
		}
	}
	
	
}

?>