<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

if (isset($_REQUEST['topic_id'])) {
	$topic_id = $_REQUEST['topic_id'];
}
else {
	header("Location: g_forum.php?group_id=" .$_REQUEST['group_id'] . "&amp;" . SID);
	exit;
}

if (isset($_REQUEST['subject_id'])) {
	$subject_id = $_REQUEST['subject_id'];
}
else {
	header("Location: g_forum_topic.php?group_id=" . $_REQUEST['group_id'] . "&amptopic_id=" . $topic_id . "&amp;" . SID);
	exit;
}


//setup
$core = "group";
include "inc/header.inc.php";
require_once($c_node['class_dir'] . 'Poll.class.php');
require_once($c_node['class_dir'] . 'Group/Forum.class.php');


//append language setup
require_once($languageArrayPath . 'arr_user_priv.lang.php');
require_once($languageArrayPath . 'arr_user_online_status.lang.php');
require_once($languageArrayPath . 'arr_language_name.lang.php');


//setup image
$image->thumb = "t1";

//setup poll
$poll = new Poll();
$poll->db = $db;
$poll->date = $date;


//setup forum
$forum = new Forum();
$forum->db = $db;
$forum->date = $date;
$forum->user_id = $me['user_id'];
$forum->topic_id = $topic_id;
$forum->subject_id = $subject_id;
$forum->image = $image;
$forum->group_id = $group_id;
$forum->poll = $poll;
$forum->node_id = $c_node['node_id'];


//update bookmarks
if (isset($_REQUEST['watch'])) {
	$forum->updateSubjectBookmark('watch');
}
elseif (isset($_REQUEST['recommend'])) {
	$forum->updateSubjectBookmark('recommend');
}
elseif (isset($_REQUEST['unwatch'])) {
	$forum->updateSubjectBookmark('unwatch');
}
elseif (isset($_REQUEST['unrecommend'])) {
	$forum->updateSubjectBookmark('unrecommend');
}


//process requests
if (isset($_POST['preview_reply'])) {
	$reply = array();
	$reply["reply_body"] = stripslashes($data["reply_body"]);
	$reply['reply_body_display'] = $reply['reply_body'];

	$display = "preview_section";

}
elseif (isset($_POST['add_reply'])) {
//$message_subject = htmlspecialchars($data['message_subject']));
	$data['reply_body'] = htmlspecialchars($data['reply_body']);
	$insert = $forum->insertReply($subject_id, $data['reply_body']);

	if ($insert == "true") {
		//update user stats
		$user->user_id = $me['user_id'];
		$user->setStatistic($c_node['user_statistic_type_id']['total_forum_replies']);

		//set group stats
		$group->setStatistic($c_node['group_statistic_type_id']['total_forum_replies']);

		//set group member stats
		$group->setGroupMemberStatistic($c_node['group_member_statistic_type_id']['total_replies'], $me['user_id']);
	}

}
elseif (isset($_POST['edit_reply'])) {
	$reply = array();
	$reply['reply_body'] = stripslashes($data['reply_body']);
}



//get subject
$output_subject = $forum->subjectDetails();


//movement
$output_subject['movement'] = $forum->getSubjectMovement('update');


$output_subject_author = $user->userDetails($output_subject['user_id']);

if (isset($output_subject['poll'])) {
	$output_poll_history = $forum->poll->pollUserVoteHistory($me['user_id']);
}

//check the poll has not ended
if (isset($output_subject['poll']['poll_end_datetime'])) {
	$datetime = date("Y-m-d H:i:s");

	if ($datetime < $output_subject['poll']['poll_end_datetime']) {
	    $ouput_allow_vote = true;
	}
}


//replies
$output_replies = $forum->replyList();

//get topic
$output_topic = $forum->topicDetails();

//get subjects
$output_subjects = $forum->subjectList();


//get related events and library docs
$output_linked_libraries = getLinkedLibraries($subject_id);
$output_linked_events = getLinkedEvents($subject_id);

//get users for each reply
if (isset($output_replies)) {
	foreach($output_replies as $key => $i):
		$output_replies[$key]['user'] = $user->userDetails($i['user_id']);

		if (isset($output_subject['poll'])) {
			$output_replies[$key]['vote'] = $forum->poll->pollUserVoteHistory($i['user_id']);
		}

	endforeach;
}

//move to template
if (isset($output_linked_events)) {
	$body->set('linked_events', $output_linked_events);
}

if (isset($output_linked_libraries)) {
	$body->set('linked_libraries', $output_linked_libraries);
}

if (isset($output_group_member_level)) {
	$body->set('group_member_level', $output_group_member_level);
}

if (isset($output_group)) {
	$body->set('group', $output_group);
}

if (isset($output_subject)) {
	$body->set('subject', $output_subject);
}

if (isset($output_replies)) {
	$body->set('replies', $output_replies);
}

if (isset($output_topic)) {
	$body->set('topic', $output_topic);
}

if (isset($output_subject_author)) {
	$body->set('author', $output_subject_author);
}

if (isset($output_subjects)) {
	$body->set('subjects', $output_subjects);
}

if (isset($display)) {
	$body->set('display', $display);
}

if (isset($reply)) {
	$body->set('reply', $reply);
}

if (isset($output_poll_history)) {
	$body->set('poll_history', $output_poll_history);
}

if (isset($ouput_allow_vote)) {
	$body->set('allow_vote', $ouput_allow_vote);
}


if (isset($output_subject['subject_title'])) {
	$template_pageLink = $lang['txt_subject'];
	$template_pageLinkNote = $output_subject['subject_title'];
}

include "inc/footer.inc.php";


/*
* getLinkedLibraries
* Tom Calthrop 31st May 2004
*/
function getLinkedLibraries ($subject_id) {

	global $db, $me, $log;

	$query = "
		SELECT distinct l.library_page_name, l.library_title
		FROM " . $db->prefix . "_group_library l
		WHERE
		forum_subject_id =" . $subject_id . "
		order by l.library_title desc"
	;

	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else {

		$temp = array();

		while (!$result->EOF) {
			$temp1 = $result->fields;

			array_push($temp, $temp1);
			$result->MoveNext();
		}

		$result->Close();

		return $temp;
	}
} //EO getLinkedLibraries();



/*
* getLinkedEvents
* Tom Calthrop 31st May 2004
*/
function getLinkedEvents ($subject_id) {

	global $db, $me, $log;

	$query = "
		SELECT e.event_id, e.event_title
		FROM " . $db->prefix . "_event e
		WHERE
		forum_subject_id =" . $subject_id . "
		order by e.event_title desc"
	;

	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else {

		$temp = array();

		while (!$result->EOF) {
			$temp1 = $result->fields;

			array_push($temp, $temp1);
			$result->MoveNext();
		}

		$result->Close();

		return $temp;
	}
} //EO getLinkedEvents();

?>
