<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------
// NOTE:
// Originating author of Text_Wiki is 
// Paul M. Jones <pmjones@ciaweb.net>
// all credit should go to him and not Barnraiser
// Shockwave Flash implementation - tom@barnraiser.org

class Text_Wiki_Render_Xhtml_Shockwaveflash extends Text_Wiki_Render {

    var $conf = array(
        'base' => '/',
        'css'  => null,
        'css_link' => null
    );
    
    
    /**
    * 
    * Renders a token into text matching the requested format.
    * 
    * @access public
    * 
    * @param array $options The "options" portion of the token (second
    * element).
    * 
    * @return string The text rendered from the token options.
    * 
    */
    
    function token($options)
    {
        // note the image source
        $src = $options['src'];
          
        // is the source a local file or URL?
        if (strpos($src, '://') === false) {
            // the source refers to a local file.
            // add the URL base to it.
            $src = $this->getConf('base', '/') . $src;
        }
        
        // stephane@metacites.net
        // is the image clickable? 
        if (isset($options['attr']['link'])) {
            // yes, the image is clickable.
            // are we linked to a URL or a wiki page?
            if (strpos($options['attr']['link'], '://')) {
                // it's a URL
                $href = $options['attr']['link'];
            } else {
                // it's a WikiPage; assume it exists.
                /** @todo This needs to honor sprintf wikilinks (pmjones) */
                /** @todo This needs to honor interwiki (pmjones) */
                /** @todo This needs to honor freelinks (pmjones) */
                $href = $this->wiki->getRenderConf('xhtml', 'wikilink', 'view_url') .
                    $options['attr']['link'];
            }
        } else {
            // image is not clickable.
            $href = null;
        }
		
        // unset so it won't show up as an attribute
        unset($options['attr']['link']);
        
        
		if (!empty($options['attr']['width'])) {
		    $width = $options['attr']['width'];
			// unset so it won't show up as an attribute
			unset ($options['attr']['width']);
		}
		else {
			$width = "100%";
		}
		
		if (!empty($options['attr']['height'])) {
		    $height = $options['attr']['height'];
			// unset so it won't show up as an attribute
			unset ($options['attr']['height']);
		}
		else {
			$height = "100%";
		}
		
		if (empty($options['attr']['allowScriptAccess'])) {
		    $options['attr']['allowScriptAccess'] = "sameDomain";
		}
		
		if (empty($options['attr']['quality'])) {
		    $options['attr']['quality'] = "high";
		}
		
		if (empty($options['attr']['bgcolor'])) {
		    $options['attr']['bgcolor'] = "#ffffff";
		}
		
		$output_object = "";
		$output_embed = "";
		
		foreach ($options['attr'] as $key => $val) {
            
           	$key = htmlspecialchars($key);
            $val = htmlspecialchars($val);
            $output_object .= "<param name=\"" . $key . "\" value=\"" . $val . "\" />\n";
			$output_embed .= $key . "=\"" . $val . "\" ";
        }
		
		
        // start the HTML output
        
		$output = "
		<object classid=\"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000\" 
		codebase=\"http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=7,0,0,0\" 
		 width=\"" . $width . "\" height=\"" . $height . "\">
		<param name=\"movie\" value=\"" . htmlspecialchars($src) . "\" />\n" .
		$output_object . "
		<embed src=\"" . htmlspecialchars($src) . "\"  width=\"" . $width . "\" height=\"" . $height . "\"   
		" . $output_embed . " 
		type=\"application/x-shockwave-flash\" 
		pluginspage=\"http://www.macromedia.com/go/getflashplayer\" />
		</object>
		";
		
        
        // was the swf clickable?
        if (!empty($href)) {
            // yes, add the href and return
            $href = htmlspecialchars($href);
            $output = "<a href=\"" . $href . "\">" . $output . "</a>";
        }
        return $output;
    }
}
?>