<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header.inc.php";
$c_node['dir']['class_path'] = $c_node['dir']['aroundme'] . $c_node['dir']['class_path'];
include $c_node['dir']['aroundme'] . "config/config_acs.inc.php";


require_once($c_node['dir']['class_path'] . 'Cms.class.php');
require_once($c_node['dir']['class_path'] . 'Blog.class.php');
require_once($c_node['dir']['class_path'] . 'Poll.class.php');
require_once($c_node['dir']['class_path'] . 'Library.class.php');
require_once($c_node['dir']['class_path'] . 'Feedcreator.class.php');

$cms = new Cms($db, null);
$cms->level_id = $c_node['cms']['cms_level']['public'];
$cms->cms_status_id = $c_node['cms']['status']['live'];


//url
$url = "http://" . $_SERVER['HTTP_HOST'];
$url .= dirname ($_SERVER['PHP_SELF']);


//SETUP RSS FEED
$rss = new UniversalFeedCreator();
$rss->useCached();
$rss->title = $lang['txt_title'];
$rss->description = $lang['txt_description'];
$rss->link = $_SERVER['HTTP_HOST'];
$rss->syndicationURL = $_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'];


//get blog ids -----------------------------------------------------
$cms->cms_item_type_id = 2;
$output_g_cms_blogs = $cms->getCmsItems();
$cms->cms_item_type_id = 1;
$output_u_cms_blogs = $cms->getCmsItems();
$output_cms_blogs = array_merge($output_g_cms_blogs, $output_u_cms_blogs);

foreach($output_cms_blogs as $key => $i):
	$cms_blog_ids[] = $i['item_id'];
endforeach;

//setup blog
$blog = new Blog($db, null, $date, null);
//get blog items
if (!empty($cms_blog_ids)) {
	$blog->blog_ids = $cms_blog_ids;
	$output_blogs = $blog->getBlogs();
}

//get group poll ids -----------------------------------------------------
$cms->cms_item_type_id = $c_node['cms']['item_type']['group_poll'];
$output_cms_polls = $cms->getCmsItems();

foreach($output_cms_polls as $key => $i):
	$cms_poll_ids[] = $i['item_id'];
endforeach;

// poll setup
$poll = new Poll($db, $c_acs['arr_section']['group'], $date);
$poll->order_by = "poll_start_datetime desc";
//get polls
if (!empty($cms_poll_ids)) {
	$poll->poll_ids = $cms_poll_ids;
	$output_polls = $poll->getPolls();
}

//get library ids -----------------------------------------------------
$cms->cms_item_type_id = $c_node['cms']['item_type']['group_library'];
$output_g_cms_library_items = $cms->getCmsItems();
$cms->cms_item_type_id = $c_node['cms']['item_type']['user_library'];
$output_u_cms_library_items = $cms->getCmsItems();
$output_cms_library_items = array_merge($output_g_cms_library_items, $output_u_cms_library_items);

foreach($output_cms_library_items as $key => $i):
	$cms_library_item_ids[] = $i['item_id'];
endforeach;

//library setup
$library = new Library($db, null, $date, null);
//get library items
if (!empty($cms_library_item_ids)) {
	$library->library_item_ids = $cms_library_item_ids;
	$output_library_items = $library->getLibraryItems();
}


//OUTPUT RSS
if (isset($output_blogs)) {
	$blog_url = $url . "/item.php?blog_id=";
	
	foreach($output_blogs as $key => $i):
	    $item = new FeedItem();
	    $item->title = $i['blog_title'];
	    $item->link = $blog_url . $i['blog_id'];
	    $item->description = $i['blog_synopsis'];
	    $item->date = $i['blog_create_datetime'];
	    $item->source = $_SERVER['HTTP_HOST']."/";
	    $item->author = "";
	    
	    $rss->addItem($item);
	endforeach;
}

if (isset($output_polls)) {
	$poll_url = $url . "/item.php?poll_id=";
	
	foreach($output_polls as $key => $i):
	    $item = new FeedItem();
	    $item->title = $i['poll_question'];
	    $item->link = $poll_url . $i['poll_id'];
	    $item->description = $i['poll_question'];
	    $item->date = $i['poll_create_datetime'];
	    $item->source = $_SERVER['HTTP_HOST']."/";
	    $item->author = "";
	    
	    $rss->addItem($item);
	endforeach;
}

if (isset($output_library_items)) {
	$library_url = $url . "/item.php?library_id=";
	
	foreach($output_library_items as $key => $i):
	    $item = new FeedItem();
	    $item->title = $i['library_title'];
	    $item->link = $library_url . $i['library_id'];
	    $item->description = $i['library_synopsis'];
	    $item->date = $i['library_create_datetime'];
	    $item->source = $_SERVER['HTTP_HOST']."/";
	    $item->author = "";
	    
	    $rss->addItem($item);
	endforeach;
}


$rss->saveFeed("RSS1.0", "feed.xml"); 





//TIDY UP
$db->Close();

?>