<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------


include "inc/header_schedule.inc.php";

if (!empty($group_id)) { // page under group section
    //ACS check
	if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group_schedule'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
		header("Location: g_group.php?group_id=" . $group_id ."&".SID);
		exit;
	}
}

unset($schedule->file, $schedule->schedule_type_id);
$schedule->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
$schedule->rsp_status_id = $c_node['rsp']['status']['live'];

if (!empty($group_id)) { // page under group section
	unset($schedule->user_id);
	$output_schedule_items = $schedule->selScheduleItems();
}
elseif ($menu_section == "my") {
    $output_schedule_items = $schedule->selScheduleItems();
}
else {
	$output_schedule_items = $schedule->selRspScheduleItems();
}


$output_schedule_items = $schedule->selScheduleItems();

//append language setup
require_once($languageArrayPath . 'arr_schedule.lang.php');


//we include the function as many ISP's do not have the calendar functions
// bound into PHP - tom
if (!function_exists('GregorianToJD')) {
	function GregorianToJD ($month,$day,$year) {
		if ($month > 2) {
		    $month = $month - 3;
		} else {
		    $month = $month + 9;
		    $year = $year - 1;
		}
		$c = floor($year / 100);
		$ya = $year - (100 * $c);
		$j = floor((146097 * $c) / 4);
		$j += floor((1461 * $ya)/4);
		$j += floor(((153 * $month) + 2) / 5);
		$j += $day + 1721119;
		return $j;
	}
}


//get the cell positions
if (!empty($output_schedule_items)) {
    $mh  = substr($output_schedule_items[0]['schedule_start_datetime'],5,2);
	$da  = substr($output_schedule_items[0]['schedule_start_datetime'],8,2);
	$yr  = substr($output_schedule_items[0]['schedule_start_datetime'],0,4);
	$startcell = GregorianToJD($mh, $da, $yr)-1;
	
	foreach($output_schedule_items as $key => $i):
	
		$mh  = substr($i['schedule_start_datetime'],5,2);
		$da  = substr($i['schedule_start_datetime'],8,2);
		$yr  = substr($i['schedule_start_datetime'],0,4);
		$maxcell = GregorianToJD($mh, $da, $yr);
		$numcell = $maxcell - $startcell;
		$output_schedule_items[$key]['cell_start'] = $numcell;
		
		$mh  = substr($i['schedule_end_datetime'],5,2);
		$da  = substr($i['schedule_end_datetime'],8,2);
		$yr  = substr($i['schedule_end_datetime'],0,4);
		$maxcell = GregorianToJD($mh, $da, $yr);
		$numcell = $maxcell - $startcell;
		$output_schedule_items[$key]['cell_end'] = $numcell;
	
	endforeach;
	

	$cells = $maxcell - $startcell;
	
	if ($cells > 30) {
	    $cells = 30;
	}
	//create gantt
	$output_schedule_items = array('items' => $output_schedule_items, 'cells' => $cells);
	
}




//move to template
if (!empty($output_group)) {
	$body->set('group', $output_group);
}

if (!empty($output_schedule_items)) {
	$body->set('schedule_items', $output_schedule_items);
}

if (!empty($c_node['activity']['task_user_status'])) {
	$body->set('task_status_ids', $c_node['activity']['task_user_status']);
}

$body->set('schedule_config', $c_node['schedule']);

if (!empty($output_activity['activity_title'])) {
	$template_pageLink = $lang['txt_activity'];
	$template_pageLinkNote = $output_activity['activity_title'];
}


include "inc/footer.inc.php";

?>
