<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

?>


<!DOCTYPE html
PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">

<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title><?php echo $lang['txt_page_title'];?></title>
<style type="text/css">
<!--
@import url(<?php echo $templatePath;?>aroundme.css);

-->
</style>
<!--[if IE]>
<style type="text/css">
@import url(<?php echo $templatePath;?>aroundme-IE.css);
</style>
<![endif]-->



<?php
//we reload an image in this template just before the session times out to
//make sure that the session does not time out
$session_maxlifetime = ini_get('session.gc_maxlifetime'); // in seconds
// we need to warn 5 minutes before
$session_warning_time = 5*60;
if ($session_maxlifetime > $session_warning_time) {
	$session_maxlifetime = $session_maxlifetime-$session_warning_time;
}
$session_maxlifetime_ms = $session_maxlifetime*1000; // in milliseconds
?>
<script type="text/javascript">
var session_id = '<?php echo session_id();?>';
var session_maxlifetime_ms = <?php echo $session_maxlifetime_ms;?>;

function ShowTimeoutWarning () {
	document.session_reload_image.src = 'get_file.php?file=session_reload_image.png&amp;sid=' + session_id;
	setTimeout( 'ShowTimeoutWarning();', session_maxlifetime_ms );
}

setTimeout( 'ShowTimeoutWarning();', session_maxlifetime_ms );
</script>

<script language="JavaScript" src="js/functions.js" type="text/javascript"></script>
<script language="JavaScript" src="speller/spellChecker.js" type="text/javascript"></script>
<script language="JavaScript">
	var baseImgURL = '<?php echo $templatePath?>img/';

	//takes form elements (text and textarea) and passes to spellchecker
	function openSpellChecker() {
		var speller = new spellChecker();
		speller.spellCheckAll();
	}

</script>

<link rel="SHORTCUT ICON" href="<?php echo $templatePath;?>img/favicon.ico" />

</head>

<body>

<div id="page">
	<div id="box_top">

		<div id="top_menu">
			<a href="sn_profile.php"><?php echo $me['firstname'];?></a>
			&nbsp;&#47;&nbsp;
			<a href="index.php"><?php echo $lang['href_logoff'];?></a>
			<br />
		</div>

		<div id="shoutbox">
			<?php
			if ($this->user_acs->checkPermission($resource_ids['shoutbox'], $privilege_ids['add_item'])) { //resourece_id, Priv_id
			?>
			<a href="sho_list.php"><?php echo $lang['href_shoutbox'];?></a>
			&nbsp;&#47;&nbsp;
			<?php
			}
			if ($this->user_acs->checkPermission($resource_ids['shoutbox'], $privilege_ids['allow_access'])) {
			if (isset($shoutbox)) {
			?>
			<a href="sn_profile.php?user_id=<?php echo $shoutbox['user_id'];?>"><?php echo $shoutbox['profile_nic'];?></a>
			&nbsp;&#47;&nbsp;<?php echo $shoutbox['shoutbox_create_datetime'];?>
			&nbsp;&#47;&nbsp;
			<?php echo $shoutbox['shoutbox_body'];?>
			<?php
			}}
			?><br />
		</div>

		<div id="main_menu">
			<table cellpadding="0" cellspacing="0" border="0" height="100%" width="100%">
				<tr>
					<td class="main_menu_td_content">
						<?php
						if (isset($section) && $section == "magazine") {
						    echo "<span class='txt_highlight2'>" . $lang['href_selection'] . "</span";
						}
						else {
						    echo "<a href='mag_overview.php'>" . $lang['href_selection'] . "</a>";
						}
						?><br />
					</td>
					<td class="main_menu_td_spacer">
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="1" alt="" border="0" /><br />
					</td>
					<td class="main_menu_td_content">
						<?php
						if (isset($section) && $section == "message") {
						    echo "<span class='txt_highlight2'>" . $lang['href_messages'] . "</span";
						}
						else {
						    echo "<a href='msg_list.php'>" . $lang['href_messages'] . "&nbsp;(" . $me['mail'] . ")</a>";
						}
						?><br />
					</td>
					<td class="main_menu_td_spacer">
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="1" alt="" border="0" /><br />
					</td>
					<td class="main_menu_td_content">
						<?php
						if (isset($section) && $section == "my") {
							echo "<span class='txt_highlight2'>" . $lang['href_me'] . "</span";
						}
						else {
						    echo "<a href='my_membership.php'>" . $lang['href_me'] . "</a>";
						}
						?><br />
					</td>
					<td class="main_menu_td_spacer">
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="1" alt="" border="0" /><br />
					</td>
					<?php
					if ($this->user_acs->checkPermission($resource_ids['social_network'], $privilege_ids['allow_access'])) { //resourece_id, Priv_id
					?>
					<td class="main_menu_td_content">

						<?php
						if (isset($section) && $section == "network") {
						    echo "<span class='txt_highlight2'>" . $lang['href_network'] . "</span";
						}
						else {
						    echo "<a href='sn_network.php'>" . $lang['href_network'] . "</a>";
						}
						?><br />
					</td>
					<td class="main_menu_td_spacer">
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="1" alt="" border="0" /><br />
					</td>
					<?php }?>
					<td class="main_menu_td_content">
						<?php
						if (isset($section) && $section == "group") {
						    echo "<span class='txt_highlight2'>" . $lang['href_groups'] . "</span";
						}
						else {
						    echo "<a href='g_groups.php'>" . $lang['href_groups'] . "</a>";
						}
						?><br />
					</td>
					<td class="main_menu_td_spacer">
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="1" alt="" border="0" /><br />
					</td>
					<td class="main_menu_td_content">
						<?php
						if (isset($section) && $section == "schedule") {
						    echo "<span class='txt_highlight2'>" . $lang['href_schedule'] . "</span";
						}
						else {
						    echo "<a href='sch_list.php'>" . $lang['href_schedule'] . "</a>";
						}
						?><br />
					</td>
					<td class="main_menu_td_spacer">
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="1" alt="" border="0" /><br />
					</td>
					<td width="100%">
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="1" alt="" border="0" /><br />
					</td>
				</tr>
			</table>
		</div>

		<div id="sub_menu">
		<?php
		if (isset($section)) {
		?>
			<table cellspacing="0" cellpadding="0" border="0" width="100%">
				<tr>
					<td valign="middle">
						<table cellpadding="0" cellspacing="0" border="0">
							<?php
							if ($section == "group") {
							?>
							<tr>
								<td valign="top">
									<span class="txt_highlight"><?php echo $lang['txt_groups'];?>:</span>&nbsp;&nbsp;
								</td>
								<td>
									<?php
									if ($page_name_short == "g_groups" && isset($display) && $display == "category") {
									?>
									<span class="txt_highlight"><?php echo $lang['menu_category'];?></span>
									<?php
									} else {
									?>
									<a href="g_groups.php"><?php echo $lang['menu_category'];?></a>
									<?php }?>
									&nbsp;&#47;&nbsp;
									<?php
									if ($page_name_short == "g_groups" && !isset($display)) {
									?>
									<span class="txt_highlight"><?php echo $lang['menu_latest_groups'];?></span>
									<?php
									} else {
									?>
									<a href="g_groups.php"><?php echo $lang['menu_latest_groups'];?></a>
									<?php }?>
									&nbsp;&#47;&nbsp;
									<?php
									if ($page_name_short == "g_groups" && isset($display) && $display == "mygroups") {
									?>
									<span class="txt_highlight"><?php echo $lang['menu_my_groups'];?></span>
									<?php
									} else {
									?>
									<a href="g_groups.php?my_groups=1"><?php echo $lang['menu_my_groups'];?></a>
									<?php }?>
									&nbsp;&#47;&nbsp;
									<?php
									if ($this->user_acs->checkPermission($resource_ids['group'], $privilege_ids['allow_create'])) { //resourece_id, Priv_id
									if ($page_name_short == "g_group_create") {
									?>
									<span class="txt_highlight"><?php echo $lang['menu_create_group'];?></span>
									<?php
									} else {
									?>
									<a href="g_group_create.php"><?php echo $lang['menu_create_group'];?></a>
									<?php }}?><br />
								</td>
							</tr>
							<?php
							}
							elseif ($section == "message") {
							?>
							<tr>
								<td valign="top">
									<span class="txt_highlight"><?php echo $lang['txt_messaging'];?>:</span>&nbsp;&nbsp;
								</td>
								<td>
									<?php
									if (isset($message_box) && $message_box == 'in_box' && $page_name_short == "msg_list") {
									?>
									<span class="txt_highlight"><?php echo $lang['href_in_box'];?></span>
									<?php
									} else {
									?>
									<a href="msg_list.php"><?php echo $lang['href_in_box'];?></a>
									<?php }?>
									&nbsp;&#47;&nbsp;
									<?php
									if (isset($message_box) && $message_box == 'out_box' && $page_name_short == "msg_list") {
									?>
									<span class="txt_highlight"><?php echo $lang['href_out_box'];?></span>
									<?php
									} else {
									?>
									<a href="msg_list.php?out_box=1"><?php echo $lang['href_out_box'];?></a>
									<?php }?>
									&nbsp;&#47;&nbsp;
									<?php
									if (isset($message_box) && $message_box == 'save_box' && $page_name_short == "msg_list") {
									?>
									<span class="txt_highlight"><?php echo $lang['href_save_box'];?></span>
									<?php
									} else {
									?>
									<a href="msg_list.php?save_box=1"><?php echo $lang['href_save_box'];?></a>
									<?php }?>
									&nbsp;&#47;&nbsp;
									<?php
									if ($page_name_short == "msg_compose") {
									?>
									<span class="txt_highlight"><?php echo $lang['href_compose'];?></span>
									<?php
									} else {
									?>
									<a href="msg_compose.php"><?php echo $lang['href_compose'];?></a>
									<?php }?>
									<br />
								</td>
							</tr>
							<?php
							}
							elseif ($section == "magazine") {
							?>
							<tr>
								<td valign="top">
									<span class="txt_highlight"><?php echo $lang['txt_splash'];?>:</span>&nbsp;&nbsp;
								</td>
								<td>
									<?php
									if ($page_name_short == "mag_overview") {
									?>
									<?php echo $lang['menu_latest'];?>
									<?php
									} else {
									?>
									<a href="mag_overview.php"><?php echo $lang['menu_latest'];?></a>
									<?php }?>
									&nbsp;&#47;&nbsp;
									<?php
									if ($page_name_short == "mag_list" && isset($blogs)) {
									?>
									<span class="txt_highlight"><?php echo $lang['menu_blog'];?></span>
									<?php
									} else {
									?>
									<a href="mag_list.php?list=blog"><?php echo $lang['menu_blog'];?></a>
									<?php }?>
									&nbsp;&#47;&nbsp;
									<?php
									if ($page_name_short == "mag_list" && isset($library_items)) {
									?>
									<span class="txt_highlight"><?php echo $lang['menu_library'];?></span>
									<?php
									} else {
									?>
									<a href="mag_list.php?list=library"><?php echo $lang['menu_library'];?></a>
									<?php }?>
									&nbsp;&#47;&nbsp;
									<?php
									if ($page_name_short == "mag_list" && isset($subjects)) {
									?>
									<span class="txt_highlight"><?php echo $lang['menu_forum_subject'];?></span>
									<?php
									} else {
									?>
									<a href="mag_list.php?list=forum_subject"><?php echo $lang['menu_forum_subject'];?></a>
									<?php }?>
									&nbsp;&#47;&nbsp;
									<?php
									if ($page_name_short == "mag_list" && isset($polls)) {
									?>
									<span class="txt_highlight"><?php echo $lang['menu_polls'];?></span>
									<?php
									} else {
									?>
									<a href="mag_list.php?list=polls"><?php echo $lang['menu_polls'];?></a>
									<?php }?><br />
								</td>
							</tr>
							<?php
							}
							elseif ($section == "my") {
							?>
							<tr>
								<td valign="top">
									<span class="txt_highlight"><?php echo $lang['txt_me'];?>:</span>&nbsp;&nbsp;
								</td>
								<td>
									<?php
									if ($page_name_short == "my_membership") {
									?>
									<?php echo $lang['menu_membership'];?>
									<?php
									} else {
									?>
									<a href="my_membership.php"><?php echo $lang['menu_membership'];?></a>
									<?php }?>
									&nbsp;&#47;&nbsp;
									<?php
									if ($page_name_short == "my_profile") {
									?>
									<?php echo $lang['menu_profile'];?>
									<?php
									} else {
									?>
									<a href="my_profile.php"><?php echo $lang['menu_profile'];?></a>
									<?php }?>
									&nbsp;&#47;&nbsp;
									<?php
									if ($page_name_short == "my_bookmarks") {
									?>
									<?php echo $lang['menu_bookmarks'];?>
									<?php
									} else {
									?>
									<a href="my_bookmarks.php"><?php echo $lang['menu_bookmarks'];?></a>
									<?php }?>
									&nbsp;&#47;&nbsp;
									<?php
									if ($page_name_short == "blg_item") {
									?>
									<?php echo $lang['menu_blog'];?>
									<?php
									} else {
									?>
									<a href="blg_item.php"><?php echo $lang['menu_blog'];?></a>
									<?php }?>
									&nbsp;&#47;&nbsp;
									<?php
									if ($page_name_short == "lib_item") {
									?>
									<?php echo $lang['menu_library'];?>
									<?php
									} else {
									?>
									<a href="lib_item.php"><?php echo $lang['menu_library'];?></a>
									<?php }?>
									&nbsp;&#47;&nbsp;
									<?php
									if ($page_name_short == "my_publishing") {
									?>
									<?php echo $lang['menu_publishing'];?>
									<?php
									} else {
									?>
									<a href="my_publishing.php"><?php echo $lang['menu_publishing'];?></a>
									<?php }?>
									&nbsp;&#47;&nbsp;
									<?php
									if ($page_name_short == "fil_list") {
									?>
									<?php echo $lang['menu_files'];?>
									<?php
									} else {
									?>
									<a href="fil_list.php"><?php echo $lang['menu_files'];?></a>
									<?php }?><br />

								</td>
							</tr>

							<?php
							}
							elseif ($section == "network") {
							?>
							<tr>
								<td valign="top">
									<span class="txt_highlight"><?php echo $lang['txt_sn'];?>:</span>&nbsp;&nbsp;
								</td>
								<td>
									<?php
									if ($page_name_short == "sn_network") {
									?>
									<?php echo $lang['menu_social_network'];?>
									<?php
									} else {
									?>
									<a href="sn_network.php"><?php echo $lang['menu_social_network'];?></a>
									<?php }?>
									&nbsp;&#47;&nbsp;
									<?php
									if ($page_name_short == "sn_invite") {
									?>
									<?php echo $lang['menu_invite_friends'];?>
									<?php
									} else {
									?>
									<a href="sn_invite.php"><?php echo $lang['menu_invite_friends'];?></a>
									<?php }?>
									&nbsp;&#47;&nbsp;
									<?php
									if ($page_name_short == "sn_blocked") {
									?>
									<?php echo $lang['menu_blocked_users'];?>
									<?php
									} else {
									?>
									<a href="sn_blocked.php"><?php echo $lang['menu_blocked_users'];?></a>
									<?php }?><br />
								</td>
							</tr>

							<?php
							}
							elseif ($section == "schedule") {
							?>
							<tr>
								<td valign="top">
									<span class="txt_highlight"><?php echo $lang['txt_schedule'];?>:</span>&nbsp;&nbsp;
								</td>
								<td>
									<?php
									if ($page_name_short == "sch_list" && isset($schedule_type_id) && $schedule_type_id !=2) {
									?>
									<?php echo $lang['menu_events'];?>
									<?php
									} else {
									?>
									<a href="sch_list.php"><?php echo $lang['menu_events'];?></a>
									<?php }?>
									&nbsp;&#47;&nbsp;
									<?php
									if ($page_name_short == "sch_list" && isset($schedule_type_id) && $schedule_type_id ==2) {
									?>
									<?php echo $lang['menu_tasks'];?>
									<?php
									} else {
									?>
									<a href="sch_list.php?schedule_type_id=2"><?php echo $lang['menu_tasks'];?></a>
									<?php }?>
									&nbsp;&#47;&nbsp;
									<?php
									if ($page_name_short == "sch_schedule") {
									?>
									<?php echo $lang['menu_schedule'];?>
									<?php
									} else {
									?>
									<a href="sch_schedule.php"><?php echo $lang['menu_schedule'];?></a>
									<?php }?>
									<br />

								</td>
							</tr>
							<?php }?>
						</table>
					</td>
					<td align="right">
							<?php
							if (isset($info_pages)) {
							?>
						<table border="0" cellspacing="0" cellpadding="2" width="100%">
							<tr>
								<td align="right">
									<span class="button_info" onclick="launchPopupWindow('man.php?paragraph_ids=<?php echo $info_pages;?>', 'quick_help', 'height=300,width=450,menubar=no,scrollbars=yes,status=no,location=no', '450');"><?php echo $lang['href_information'];?></span><br />
								</td>
							<tr>
						</table>
							<?php }?>
					</td>
				</tr>
			</table>
		<?php }?>
		</div>
	</div>

	<div id="box_bottom">
		<table cellpadding="0" cellspacing="0" border="0" width="100%">
			<tr>
				<td align="left">
					<img src="<?php echo $templatePath;?>img/box_bottom_left.png" width="5" height="18" alt="" border="0" /><br />
				</td>
				<td align="left">
					<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="9" alt="" border="0" /><br />
				</td>
				<td align="right">
					<img src="<?php echo $templatePath;?>img/box_bottom_right.png" width="5" height="18" alt="" border="0" /><br />
				</td>
			</tr>
		</table>
	</div>


	<?php
	if (isset ($breadcrumb)) {
	?>
	<div id="breadcrumb">
	 	<span class="txt_highlight">history:</span>&nbsp;&nbsp;
		<?php
		foreach($breadcrumb as $key => $i):
			if(isset($i['breadcrumb_title'])) {

				if (count($breadcrumb) == $key+1) {
				    echo $i['breadcrumb_title'];
				}
				else {
					echo "<a href='" . $i['breadcrumb_url'] . "' title='" . $i['breadcrumb_note'] . "'>" . $i['breadcrumb_title'] . "</a>&nbsp;&nbsp;&#47;&nbsp;&nbsp;";
				}
			}
		endforeach;
		?><br />
	</div>
	<?php }?>

	<?php
	if (isset($log)) {
	?>
	<div id="box_error">
		<?php
		foreach($log as $key => $i):
			if (isset($i[0])) {
				unset($error);
				if (isset($error_handling) && $error_handling>0 && isset($i[1])) {
					$error = $lang['arr_error'][$i[0]] . ": " . $i[2] . "<br />";
				}
				elseif (empty($i[1])) {
					$error = $lang['arr_error'][$i[0]] . "<br />";
				}
			}

			if (isset($error)) {
				echo "<p>" . $error . "</p>";
			}
		endforeach;
		?>
	</div>

	<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="6" alt="" border="0" /><br />

	<?php }?>


	<div id="content">
		<?php echo $content;?>
	</div>

	<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="6" alt="" border="0" /><br />

	<form action="search.php" method="post">
	<div id="bottom_menu">
		<table cellpadding="0" cellspacing="0" border="0" width="100%">
			<tr>
				<td align="left">
					<div id="bottom_menu_content">
					<?php
					if (empty($_POST) && $page_name_short != "report_abuse") { //we do not want them to report abuse after they post as it will create a page error as we cannot re-pass the POST data to the page
						$url = $_SERVER['REQUEST_URI'];
						if (substr($url, -4) == ".php") {
						    $url .= "?";
						}
						else {
						    $url .= "&amp;";
						}
						$url .= "abuse_report=1";
					?>
					<a href="<?php echo $url;?>"><?php echo $lang['href_report_abuse'];?></a>
					<?php }?>
					&nbsp;&#47;&nbsp;
					<a href="welcome.php"><?php echo $lang['href_help'];?></a>
					&nbsp;&#47;&nbsp;
					<a href="node_structure.php"><?php echo $lang['href_node_structure'];?></a>
					&nbsp;&#47;&nbsp;
					<?php
					if ($this->user_acs->checkPermission($resource_ids['administration'], $privilege_ids['allow_access'])) { //resourece_id, Priv_id
					?>
					<a href="node_admin.php"><?php echo $lang['href_node_admin'];?></a>
					&nbsp;&#47;&nbsp;
					<?php }?>
					<a href="http://www.barnraiser.org/"><?php echo $lang['href_node_feedback'];?></a>
					<br />
					</div>
				</td>
				<td align="right">
					<div id="bottom_menu_content">
						<?php
						if (isset($toolbar_bookmark_url)) {
						?>

						<?php
						if (isset($toolbar_watch)) {
						?>
						<a href="<?php echo $toolbar_bookmark_url;?>&amp;unwatch=1" title="<?php echo $lang['href_unwatch_this'];?>">
						<img src="<?php echo $templatePath;?>img/toolbar_bookmark-minus.png" width="18" height="19" hspace="3" alt="<?php echo $lang['href_unwatch_this'];?>" border="0" /></a>

						<?php
						}
						else {
						?>
						<a href="<?php echo $toolbar_bookmark_url;?>&amp;watch=1" title="<?php echo $lang['href_watch_this'];?>">
						<img src="<?php echo $templatePath;?>img/toolbar_bookmark-plus.png" width="18" height="19" hspace="3" alt="<?php echo $lang['href_watch_this'];?>" border="0" /></a>
						<?php
						}
						?>
						<?php
						if (isset($toolbar_recommend)) {
						?>
						<a href="<?php echo $toolbar_bookmark_url;?>&amp;unrecommend=1" title="<?php echo $lang['href_unrecommend_this'];?>">
						<img src="<?php echo $templatePath;?>img/toolbar_recommend-minus.png" width="18" height="18" hspace="3" alt="<?php echo $lang['href_unrecommend_this'];?>" border="0" /></a>
						<?php
						}
						else {
						?>
						<a href="<?php echo $toolbar_bookmark_url;?>&amp;recommend=1" title="<?php echo $lang['href_recommend_this'];?>">
						<img src="<?php echo $templatePath;?>img/toolbar_recommend-plus.png" width="18" height="18" hspace="3" alt="<?php echo $lang['href_recommend_this'];?>" border="0" /></a>
						<?php }?>
						<?php }?>

						<?php
						if (isset($toolbar_printc)) {
						?>
						<a href="<?php echo $toolbar_printc;?>" title="<?php echo $lang['txt_print_view_comments'];?>"><img src="<?php echo $templatePath;?>img/toolbar_print-c.png" width="24" height="16" hspace="3" alt="" border="0" /></a>
						<?php }?>
						<?php
						if (isset($toolbar_print)) {
						?>
						<a href="<?php echo $toolbar_print;?>" title="<?php echo $lang['txt_print_view'];?>"><img src="<?php echo $templatePath;?>img/toolbar_print.png" width="21" height="16" hspace="3" alt="" border="0" /></a>
						<?php }?>
						<br />
					</div>
				</td>

				<td class="main_menu_td_spacer" width="1">
					<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="1" alt="" border="0" /><br />
				</td>
				<td valign="middle" align="right" width="1%">
					<div id="bottom_menu_content" style="padding-right: 6px;">
					<table cellpadding="0" cellspacing="0" border="0">
						<tr>
							<td nowrap="nowrap">
								<?php echo $lang['href_search'];?><br />
							</td>
							<td>
								<img src="<?php echo $templatePath;?>img/pixel.png" width="6" height="1" alt="" border="0" /><br />
							</td>
							<td>
								<input type="text" name="search_text" size="10" class="searchbox" /><br />
							</td>
							<td>
								<img src="<?php echo $templatePath;?>img/pixel.png" width="6" height="1" alt="" border="0" /><br />
							</td>
							<td>
								<input type="image" src="<?php echo $templatePath;?>img/search.png" /><br />
							<td>
						</tr>
					</table>
					</div>
				</td>
			</tr>
		</table>
	</div>

	<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="9" alt="" border="0" /><br />

	<!-- under our free license policy you are allowed to remove this, however we would obviously like it if you chose to promote us through including the following text/link/logo --->
 	<table cellpadding="6" cellspacing="0" border="0" width="100%">
		<tr>
			<td align="left" valign="top">
				<a href="http://www.barnraiser.org/aroundme/"><img src="<?php echo $templatePath;?>img/aroundme.png" width="180" height="56" alt="" border="0" /></a><br />
			</td>
			<td width="50">
				<img src="<?php echo $templatePath;?>img/pixel.png" width="40" height="1" alt="" border="0" /><br />
			</td>
			<td align="left" valign="middle" id="breadcrumb">
				 <?php echo $lang['txt_strap'];?><br />
			</td>
		</tr>
	</table>

	<img name="session_reload_image" src="get_file.php?file=session_reload_image.png" />

</form>

</div>
</body>
</html>
