<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------
// Tom Calthrop - 20th April 2004 (tom@barnraiser.org)



// STATUS IDS -----------------------------------------------------

$lang['man'][1] =  <<< eof
<table width="280" border="0" cellspacing="0" cellpadding="0">
	<tr>
		<td>
			<b>WIKI content - formatting text</b><br />
			<a href="#bold">bold text</a><br />
			<a href="#code">code</a><br />
			<a href="#heading">heading</a><br />
			<a href="#hr">horizontal rule</a><br />
			<a href="#break">line breaks</a><br />
			<a href="#blockquote">blockquote</a><br />
			<a href="#lists">lists</a><br />
			<a href="#table">table</a><br />
			<a href="#image">image</a><br />
			<a href="#toc">toc</a><br />
			<a href="#centre">centre</a><br />
			<a href="#raw">raw</a><br />
			<a href="#links">links</a><br />
			<a href="#url">urls</a><br />
			<a href="#textcolor">text color</a><br />
			<a href="#tt">teletype text</a><br />
			<a href="#italic">italic text</a><br />
		</td>
	</tr>
	<tr>
		<td>
			<hr />
			<a name="bold">
			<p>
			<b>BOLD</b><br />
			You can make any text <b>bold</b> by putting three apostrphe's before and after the word(s) like:
			</p>

			<p>'''words to bold'''</p>

			<p><b>words to bold</b></p>

			<a href="#">back to the top</a><br />
			<br />
		</td>
	</tr>
	<tr>
		<td>
			<hr />
			<a name="code">
			<p><b>CODE</b><br />

			For technical manuals you may wish to write code examples by enclosing the code in
			&lt;code&gt;a code tag &lt;/code&gt;. You can also specify a &quot;type&quot;
			as either &quot;php&quot; or &quot;html&quot;.</p>

			<p>&#60;code type="php"&#62;text&#60;code&#62;<br />

			<code><br />
			<span style="color:#0000CC">&lt;?php</span><br />
			<span style="color:#FF9900">// comment</span><br />
			<span style="color:#0000CC">&#36;variable </span><br />
			<span style="color:#006600">= </span><span style="color:#CC0000">'Hello world!';</span><br />
			<span style="color:#006600">echo(</span><br />
			<span style="color:#0000CC">&#36;variable</span><br />
			<span style="color:#006600">);</span><br />
			<span style="color:#0000CC">?&gt;</span><br />
			</code><br />

			<a href="#">back to the top</a><br />
			<br />
		</td>
	</tr>
	<tr>
		<td>
			<hr />
			<a name="heading">

			<p><b>HEADING</b><br />
			How big you want your heading text. Just put a plus sign (+) in front of the text.</p>

			<h1 id="toc0">+ Heading Level 1</h1>
			<h2 id="toc1">++ Heading Level 2</h2>
			<h3 id="toc2">+++ Heading Level 3</h3>
			<h4 id="toc3">++++ Heading Level 4</h4>

			<h5 id="toc4">+++++ Heading Level 5</h5>
			<h6 id="toc5"> ++++++ Heading Level 6</h6>
			<a href="#">back to the top</a><br />
			<br />
		</td>
	</tr>
	<tr>
		<td>
			<hr />
			<a name="hr">
			<p><b>HORIZONTAL RULE</b><br />
			on a line by itself at the beginning of the line put ---- to create a horizontal rule:<br />
			</p>
			<a href="#">back to the top</a><br />
			<br />
		</td>
	</tr>
	<tr>
		<td>
			<hr />
			<a name="break">
			<p><b>BREAK</b><br />
			You may want to create an explicit line break (force a line break). You can use it in
			lists, tables, etc. to break lines without breaking the element. Any line ending with
			a space and an underscore will create a break.</p>

			<p>The quick brown _<br />
			foxs jumps over<br />
			the lazy dog.</p>

			<p>The quick brown<br />
			foxs jumps over <br />
			the lazy dog.</p>
			<a href="#">back to the top</a><br />
			<br />
		</td>
	</tr>
	<tr>
		<td>
			<hr />
			<a name="blockquote">

			<p><b>BLOCKQUOTE</b><br />
			Any line starting with one or more &gt; signs, followed by a space will create a blockquote:</p>

			<blockquote><p>one &gt; is one tab in (blockquote)</p>
			<blockquote><p>two&gt;&gt; is two tab in (blockquotes)</p>
			</blockquote>
			</blockquote>
			<a href="#">back to the top</a><br />
			<br />
		</td>
	</tr>
	<tr>
		<td>
			<hr />
			<a name="lists">
			<p><b>LISTS</b><br />
			Use this to create ordered lists with a # character, or unordered lists with a * marker.
			Adding spaces before the marking indents the list items. You can mix ordered and
			unordered lists. If you put a blank line between list item lines, you will start
			a new list.</p>

			<p># one<br />
			# two </p>

			<ol>
			 <li>one</li>
			 <li>two </li>
			</ol>

			<p>* three<br />
			* four</p>

			<ul>
			 <li>three</li>
			 <li>four</li>
			</ul><a href="#">back to the top</a><br />
			<br />
		</td>
	</tr>
	<tr>
		<td>
			<hr />
			<a name="table">
			<p><b>TABLE</b><br />
			| | at the beginning of a line, with || to separate cells, and | | at the end of the
			line, with optional alignment character (&lt; for left, = for center, &gt; for
			right)</p>

			<p>|| Cell 1 || Cell 2 ||<br />
			|| Cell 3 || Cell 4 ||</p>


			<table>
				<tr>
					<td>Cell 1</td>
					<td>Cell 2</td>
				</tr>
				<tr>
					<td>Cell 3</td>
			 		<td>Cell 4</td>
				</tr>
			</table>

			<p>You can span cells by using more than one set of | | markers.</p>

			<p>|| Cell 1 || Cell 2 ||<br />
			|||| Cell span ||</p>

			<table>
				<tr>
					<td>Cell 1</td>
					<td>Cell 2</td>
				</tr>
				<tr>
					<td colspan="2">Cell span</td>
				</tr>
			</table>

			<p>You can align the contents of a cell by including a &lt;, =, or &gt; character
			after the || marker.</p>

			<p>||< left ||= center ||> right ||<br />
			|| The quick brown || fox jumps over || the lazy dog. ||</p>

			<table>
				<tr>
					<td style="text-align: left;">left</td>
					<td style="text-align: center;">center</td>
					<td style="text-align: right;">right</td>
				</tr>
				<tr>
					<td>The quick brown</td>
					<td>fox jumps over</td>
					<td>the lazy dog.</td>
				</tr>
			</table>

			<p>If you include a blank line between table lines, you will start a new table.</p>

			<p>|| cell 1 || cell 2 ||</p>
			<p>|| cell 3 || cell 4 ||</p>

			<table>
				<tr>
					<td>cell 1</td>
					<td>cell 2</td>
				</tr>
			</table>

			<table>
				<tr>
					<td>cell 3</td>
					<td>cell 4</td>
				</tr>
			</table>
			<a href="#">back to the top</a><br />
			<br />
		</td>
	</tr>
	<tr>
		<td>
			<hr />
			<a name="image">

			<p><b>IMAGE</b><br />
			You can place an image in your document. You may optionally link to another page
			in the wiki, and you may optionally indicate HTML attributes for your image, such
			as 'align' and 'hspace'. There can be no spaces in the image file name, and the
			macro arguments must be of the form 'arg=&quot;value&quot;'.</p>

			<p>Look in your images and see the filename of your image:</p>

			<p>[[image 2_t2.jpg]]<br />
			[[image 2_t2.jpg align="left" hspace="8"]]</p>

			<p><img src="../../../asset_aGFT6/group/2_t2.jpg" alt="2_t2.jpg" /></p>

			<p><img src="../../../asset_aGFT6/group/2_t2.jpg" align="left" hspace="8" alt="2_t2.jpg" /></p>

			<p>You can make the image a link to a page in the wiki by adding a link=&quot;...&quot; argument:</p>

			<p>[[image 2_t2.jpg link="FormatingFields"]]</p>

			<p><a href="FormatingFields"><img src="../../../asset_aGFT6/group/2_t2.jpg" alt="2_t2.jpg" /></a></p>

			<p>Barnraiser limits the amount of space you have for storing images. This is because we need to pay for that space. If you need more you can either pay us a small fee to increase your space or create links to images in other sites (note: remember that you must observe copyright laws)</p>

			<p>You can put a picture in a page by typing the URL to the picture (it must end in gif, jpg, or png).</p>

			<p>http://www.smudge.com/asset/kosovo_107_t1.jpg</p>

			<p><img src="http://www.smudge.com/asset/kosovo_107_t1.jpg" alt="http://www.smudge.com/asset/kosovo_107_t1.jpg" /></p>

			<p>You can use the described-reference URL markup to give the image an ALT tag. You should do this as it helps people with visual disabilities. It also means that when you roll over the image with your mouse you see the ALT tag:</p>

			<p>[http://www.smudge.com/asset/kosovo_107_t1.jpg Pristina/Prishtina Library]</p>

			<p><img src="http://www.smudge.com/asset/kosovo_107_t1.jpg" alt="Pristina/Prishtina Library with ugly fountain;)" /></p>
			<a href="#">back to the top</a><br />
			<br />
		</td>
	</tr>
	<tr>
		<td>
			<hr />
			<a name="toc">
			<p><b>TABLE OF CONTENTS</b><br />
			Looks through all the heading elements in the source text and creates a table of
			contents from them; each table of contents entry is linked to the appropriate
			heading, so you can click on it to go to the heading.</p>

			<p>[[toc]]<br />
			<div id="toc"><strong>Table of Contents</strong>
			<div style="margin-left: -1em;"><a href="#toc0">+ Heading Level 1</a></div>
			<div style="margin-left: 0em;"><a href="#toc1">++ Heading Level 2</a></div>
			<div style="margin-left: 1em;"><a href="#toc2">+++ Heading Level 3</a></div>
			<div style="margin-left: 2em;"><a href="#toc3">++++ Heading Level 4</a></div>
			<div style="margin-left: 3em;"><a href="#toc4">+++++ Heading Level 5</a></div>

			<div style="margin-left: 4em;"><a href="#toc5"> ++++++ Heading Level 6</a></div>
			</div>
			<br />
			<a href="#">back to the top</a><br />
			<br />
		</td>
	</tr>
	<tr>
		<td>
			<hr />
			<a name="centre">
			<b>CENTRE</b><br />
			Any line starting with an = sign followed by a space will center a paragraph line:</p>

			<p>= This line is centered.</p>

			<p><div style="text-align: center;">This line is centered.</div></p>
			<a href="#">back to the top</a><br />
			<br />
		</td>
	</tr>
	<tr>
		<td>
			<hr />
			<a name="raw">

			<p><b>RAW</b><br />
			Use this when you want to mark text that should not be processed by the remaining
			Text_Wiki rules (i.e., it should be displayed literally as it is).</p>

			<p><strong>I'm strong!</strong>  **I'm strong!**</p>
			<a href="#">back to the top</a><br />
			<br />
		</td>
	</tr>
	<tr>
		<td>
			<hr />
			<a name="links">

			<p><b>LINKS</b><br />
			You can make a link by simply typing some words together (called smashing words
			together) with a CAPS at the start of each word !LikeTheseWords. For instance
			this page name is called FormatingFields.</p>

			<p>If you want to create a new page in the !ThenTypeSomethingNew and you will
			see a questionmark appear after it like  !ThenTypeSomethingNew[?]. This means
			that the page has not been created yet, however if you then click on the link
			the page will be created and you can type information into it.</p>

			<p>If you do not want the text to create a link up an exclamation mark in front
			of it:</p>

			<p>!ThenTypeSomethingNew</p>

			<p>You can create a &quot;described&quot; or &quot;labeled&quot; link to a wiki
			page by putting the page name in brackets, followed by some text.</p>

			<p>[FormatingFields This is a link to this page]</p>

			<p>[FormatingFields This is a link to this page]</p>
			<a href="#">back to the top</a><br />
			<br />
		</td>
	</tr>
	<tr>
		<td>
			<hr />
			<a name="url">

			<p><b>URL's</b><br />
			Create a remote link by simply typing in it's url:
			<a href="http://www.barnraiser.org/" onclick="window.open(this.href, '_blank'); return false;">http://www.barnraiser.org/</a> .</p>

			<p>Remember to include the whole url including the http: segment.
			You do not need to put the trailing slash, however it is good policy
			to do so.</p>

			<p>If you like, enclose it in brackets to create a numbered reference
			and avoid cluttering the page; [http://www.barnraiser.org/] becomes:</p>

			<p>The Barnraiser organisation made this <sup><a href="http://www.barnraiser.org/" onclick="window.open(this.href, '_blank'); return false;">1</a></sup></p>

			<p>Or you can have a described-reference instead of a numbered reference:</p>

			<p>[http://www.barnraiser.org/ Barnraiser is super cool]</p>

			<p><a href="http://www.barnraiser.org/" onclick="window.open(this.href, '_blank'); return false;">Barnraiser is super cool</a></p>
			<a href="#">back to the top</a><br />
			<br />
		</td>
	</tr>
	<tr>
		<td>
			<hr />
			<a name="textcolor">
			<p><b>TEXTCOLOR</b><br />
			You can color text like this:</p>

			<p>##red|This is red text, ## but this is not.</p>

			<p><span style="color: aqua;">This is aqua text, </span> but this is not.<br />
			<span style="color: black;">This is black text, </span> but this is default browser text colour.<br />
			<span style="color: blue;">This is blue text, </span> but this is not.<br />
			<span style="color: fuchsia;">This is fuchsia text, </span> but this is not.<br />

			<span style="color: gray;">This is gray text, </span> but this is not.<br />
			<span style="color: green;">This is green text, </span> but this is not.<br />
			<span style="color: lime;">This is lime text, </span> but this is not.<br />
			<span style="color: maroon;">This is maroon text, </span> but this is not.<br />
			<span style="color: olive;">This is olive text, </span> but this is not.<br />

			<span style="color: purple;">This is purple text, </span> but this is not.<br />
			<span style="color: red;">This is red text, </span> but this is not.<br />
			<span style="color: silver;">This is silver text, </span> but this is not.<br />
			<span style="color: teal;">This is teal text, </span> but this is not.<br />
			<span style="color: yellow;">This is yellow text, </span> but this is not.</p>

			<p>If you are familiar with hex code you can also use those:</p>

			<p>More text, and then ##ff9933|this is kind of orange.##</p>

			<p>More text, and then <span style="color: #ff9933;">this is kind of orange.</span></p>
			<a href="#">back to the top</a><br />
			<br />
		</td>
	</tr>
	<tr>
		<td>
			<hr />
			<a name="tt">
			<p><b>TELETYPE TEXT</b><br />
			To create teletype (monospace) text:</p>

			<p>This is {{teletype}} text.</p>

			<p>This is <tt>teletype</tt> text.</p>
			<a href="#">back to the top</a><br />
			<br />
		</td>
	</tr>
	<tr>
		<td>
			<hr />
				<a name="italic">
				<p><b>ITALIC TEXT</b><br />
				To create italic text:</p>

				<p>This is ''italic'' text.</p>

				<p>This is <i>italic</i> text.</p>

				<br />
				<a href="#">back to the top</a><br />
				<br />
		</td>
	</tr>
</table>
eof;

$lang['man'][2] = <<< eof
	<p>
	<b>Events</b><br />
	An event is typically a social gathering or an activity. You can add an event for your group here.<br />
	</p>
	<p>
	The first form you see is a basic Event page. You only need to fill this in to enter your form. Pressing 'SAVE' will save the form and pressing 'SAVE AND GO' will save the form and then take you to the event details page.<br />
	</p>
eof;


$lang['man'][3] = <<< eof
	<p>
	<b>Description</b><br />
	You can press 'description' to add a detailed description to your event. You can include pictures and links to other web sites.<br />
	</p>
eof;

$lang['man'][4] = <<< eof
	<p>
	<b>Occurrence</b><br />
	If you wish to repeat this event; for example weekly or yearly you can change the occurrence of the event.<br />
	</p>
eof;

$lang['man'][5] = <<< eof
	<p>
	<b>Attendance</b><br />
	You can add an attendance figure. If you do this then people can apply to attend this event.<br />
	</p>
eof;

$lang['man'][6] = <<< eof
	<p>
	Note: Once an event is added you cannot delete it. Just set it to 'cancelled' instead and it will not show.<br />
	</p>
eof;

$lang['man'][7] = <<< eof
	<p>
	A blog is a short name for 'web log'. It is an Internet based diary. You can add blogs and publish them to your friends or the entire community. People use blogs for a wide plethora of reasons - you can tell your friends what you are up to or publish a manifesto for peace.<br />
	</p>
eof;

$lang['man'][8] = <<< eof
	What are events.....

eof;

$lang['man'][9] = <<< eof
	how to work the calendar:

	Date selection:
	- Use the <<, >> buttons to select year.
	- Use the <, > buttons to select month.
	- Hold mouse button on any of the above buttons for faster selection.

	Time selection:
	- Click on any of the time parts to increase it.
	- or Shift-click to decrease it.
	- or click and drag for faster selection.

eof;

$lang['man'][10] = <<< eof
wiki default items:

When you edit your wiki page you may see a checkbox called "default page". When someone visits your wiki, the default page is the first page that someone sees. If your page is the default page you will not see anything, however if it is not you have the option to make it into your default page.

eof;


$lang['man'][11] = <<< eof
Group Roles:
Each member of a group is assigned a role. Examples could be 'General secretary', 'Administrator' or 'moderator'. You can assign roles to your group in the 'permissions page'. When new members join the group they are automatically assigned a role. This is called 'the default role' and you can change this in the 'permissions page'.

Group Permissions:
allow access = give the member permission to view this section of the group.
allow edit = give the member permission to edit, delete or add items to section of the group.
allow comment = give the member permission to add comments to items in this section of the group.

eof;


$lang['man'][12] = <<< eof
TOPICS:
You can only delete a topic if their are no subjects under it. If you wish to delete a topic edit the subjects under it and move them to another topic first.

eof;


$lang['man'][13] = <<< eof
wiki:
The Hawaiian term wiki wiki, meaning "quick" or "super-fast".

A wiki enables documents to be written collectively in a simple markup language using a web browser. A single page in a wiki is referred to as a "wiki page", while the entire body of pages, which are usually highly interconnected via hyperlinks, is called "the wiki."

A defining characteristic of wiki technology is the ease with which pages can be created and updated. Generally, there is no review before modifications are accepted.

You can use your wiki as a web site in which to write documents such as manuals, cv's or detailed information about your interests. You can add pictures to support your work or create picture galleries.

eof;
?>