<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------


include "inc/header_schedule.inc.php";

if (!empty($group_id)) { // page under group section
    //ACS check
	if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group_schedule'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
		header("Location: g_group.php?group_id=" . $group_id ."&".SID);
		exit;
	}
}


   //see if we have a start date
if(!empty($frmdata['start_date'])) { // default is today
	$frmdata['start_date'] = $date->formatFormDateTime($frmdata['start_date']);
	$schedule->start_date = $frmdata['start_date'];
}
else {
	$frmdata['from_date'] = date("Y-m-d"); //now
}


if(!empty($frmdata['schedule_show'])) { //default is 5
	$schedule->no_of_days_shown = $frmdata['schedule_show'];
}

unset($schedule->file);

if (!empty($group_id)) { // page under group section
	$schedule->group_id = $group_id;
	
	$schedule->schedule_type_id = $c_node['schedule']['type']['event'];
	$output_schedule_events = $schedule->selScheduleItems();
	
	$schedule->schedule_type_id = $c_node['schedule']['type']['task'];
	$output_schedule_tasks = $schedule->selScheduleItems();
	
	$display = "group_schedule";
}
else { // my schedule

	$schedule->user_id = $me['user_id'];
	$schedule->schedule_type_id = $c_node['schedule']['type']['event'];
	$output_schedule_events = $schedule->selMyScheduleItems();
	
	$schedule->schedule_type_id = $c_node['schedule']['type']['task'];
	$output_schedule_tasks = $schedule->selMyScheduleItems();
}




//move to template
if (!empty($output_group)) {
	$body->set('group', $output_group);
}

if (!empty($output_schedule_events)) {
	$body->set('schedule_events', $output_schedule_events);
}

if (!empty($output_schedule_tasks)) {
	$body->set('schedule_tasks', $output_schedule_tasks);
}

if (!empty($output_schedule['schedule_title'])) {
	$template_pageLink = $lang['txt_bc_schedule'];
	$template_pageLinkNote = $output_schedule['schedule_title'];
}

if (!empty($display)) {
	$body->set('display', $display);
}

$body->set('allocation_status', $lang['schedule']['allocation_status']);
$body->set('schedule_config', $c_node['schedule']);


$body->set('languagePath', $languagePath); //for calendar lang config
$tpl->set('info_pages', '9'); //setup help button

include "inc/footer.inc.php";

?>
