<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------
// Tom Calthrop (info@barnraiser.org)


// RELEASE NOTES --------------------------------------------------
$c_node['release']['version'] = 					"0.5.2";
$c_node['release']['release_date'] = 				""; // MM-DD-YYYY
$c_node['release']['install_date'] = 				"07-23-2005"; // MM-DD-YYYY


//DATABASE CONFIGURATION --------------------------------------------------
$c_node['db']['driver'] = 							"mysql";
$c_node['db']['host'] = 							"localhost";
$c_node['db']['user'] = 							"your_db_username";
$c_node['db']['pass'] = 							"your_db_password";
$c_node['db']['db']=	 							"your_db_name";
$c_node['db']['prefix'] =	 						"am";


// MAIL CONFIGURATION ----- ----------------------------------------------
// phpMailer. See http://phpmailer.sourceforge.net/ for settings.
$c_node['mail']['host'] = 							"your_mail_server.com";
$c_node['mail']['no_reply_address'] = 				"nopreply@your_mail.org";
$c_node['mail']['default_address'] = 				"you@your_mail.org";
$c_node['mail']['mailer'] = 						"smtp";
$c_node['mail']['from_name'] = 						"company_name";
$c_node['mail']['wordwrap'] = 						"80";
// This is the language for error messages which are not written to screen, so
// it's not worth changing adjusting this
$c_node['mail']['language'] = 						"en";
//if you need a username and password to access SMTP then uncomment these 
// and add your username and password
//$c_node['mail']['smtp']['username'] = 			"your_username";
//$c_node['mail']['smtp']['password'] = 			"your_password";


// PHP CONFIGURATION -----------------------------------------------------
//ini_set('error_reporting', E_ALL);//error handling in development environment
ini_set('error_reporting', 0); //error handling in production environment
ini_set('session.gc_maxlifetime', '2880');	//length of session time

// DIRECTORY CONFIGURATION --------------------------------------------------
// local path to assets directory-"/public_html/asset/"
$c_node['dir']['asset_path'] = 						"../asset/";
// path to the templates directory
$c_node['dir']['template_path'] = 					"template/";
// path to the class directory
$c_node['dir']['class_path'] = 						"class/";


// LOG CONFIGURATION -----------------------------------------------------.
// set to true to write to log file / false not to.
$c_node['log'] = 									false;



//CRON-CONFIGURATION ----------------------------------------------
// set bulk_email to "0" if you wish to use cron
$c_node['cron']['bulk_email'] = 					"0";

// newsletter config
$c_node['newsletter']['type']['node'] = 			"1";  // node-members
$c_node['newsletter']['type']['group'] = 			"2";  // group
$c_node['newsletter']['type']['event'] = 			"3";  // event
$c_node['newsletter']['type']['node_pending'] = 	"4";  // node-pending
$c_node['newsletter']['type']['node_invited'] = 	"5";  // node-invited
// number of emails to be sent per batch
$c_node['newsletter']['nr_per_batch'] = 			"10";



// NODE CONFIGURATION ----------------------------------------------------
$c_node['node']['node_id'] = 						"1"; // always set to 1
$c_node['node']['template_default_name'] = 			"barnraiser_01";
$c_node['node']['template_default_id'] = 			"1";
//debug mode - set to 1 to see database error, null just returns user errors
$c_node['node']['debug_mode'] = 					"1";
// do you want users to be able to register for this node? (0=off, 1=on)
$c_node['node']['allow_registration'] = 			"1";
// do you want users to invite others when registering? (0=off, 1=on)
$c_node['node']['allow_setup_invites'] = 			"1";
// do you want users to be able to retrieve a new password? (0=off, 1=on)
$c_node['node']['allow_new_password'] = 			"1";
//default home page (inserted in DB upon registration
$c_node['node']['page_default'] = 					"welcome.php";


// LANGUAGE ----------------------------------------------------------------
// list within the array the language ID's available to this node.check
// you have the language files installed before extending this.
$c_node['node']['language']['default'] = 			"1"; //English
//UK (real) English / help group 1 /aspell lang
$c_node['node']['language']['pack'][1] = 			array('eng', 1, 'en'); 


// DICTIONARY
// if Aspell is installed you can configure to show a spellchecker button
// standard aspell installs are either:
// WINDOWS -> '"C:\Program Files\Aspell\bin\aspell.exe"'
// (use the double quotes inside the single quotes)
// GNU/Linux -> "/usr/local/bin/aspell"
// Leave the command blank "" to tell aroundme NOT TO show shellchecker
$c_node['node']['language']['aspell']['command'] = 	'"C:\Program Files\Aspell\bin\aspell.exe"';




// FILE CONFIGURATION ----------------------------------------------------
$c_node['file']['default_max_user_space'] = 		"50000";
$c_node['file']['default_max_group_space'] = 		"50000";



// MIME CONFIGURATION ----------------------------------------------------
//full list at http://www.phpfreaks.com/mimetypes.php
//make sure you think about the implications for viruses before editing this
//edit the functions.inc.php formatFileOuptput functions to create correct html output
$c_node['file']['mime'][1]['mime'] = 				"image/jpeg";
$c_node['file']['mime'][1]['suffix'] = 				"jpg";
$c_node['file']['mime'][2]['mime'] = 				"image/png";
$c_node['file']['mime'][2]['suffix'] = 				"png";
$c_node['file']['mime'][3]['mime'] = 				"image/gif";
$c_node['file']['mime'][3]['suffix'] = 				"gif";
$c_node['file']['mime'][4]['mime'] = 				"application/pdf";
$c_node['file']['mime'][4]['suffix'] = 				"pdf";
$c_node['file']['mime'][5]['mime'] = 				"text/plain";
$c_node['file']['mime'][5]['suffix'] = 				"txt";
//image and thumbs
$c_node['file']['image']['max_width'] = 			"520"; //main image
$c_node['file']['image']['thumb_directory'] = 		"thumbs/";
$c_node['file']['image']['thumb'][1]['name'] =		"t1";
$c_node['file']['image']['thumb'][1]['noimage'] =	"no_file_t1.png";
$c_node['file']['image']['thumb'][1]['width'] =		"158";
$c_node['file']['image']['thumb'][2]['name'] =		"t2";
$c_node['file']['image']['thumb'][2]['width'] =		"80";
$c_node['file']['image']['thumb'][2]['noimage'] =	"no_file_t2.png";
$c_node['file']['image']['thumb'][3]['name'] =		"t3";
$c_node['file']['image']['thumb'][3]['width'] =		"32";
$c_node['file']['image']['thumb'][3]['noimage'] =	"no_file_t3.png";
//name of "broken image" image is displayed if the file cannot be found
$c_node['file']['image']['broken_image'] =			"broken_image.png";

//sometimes MIME types vary from browser to browser - this array will convert
//other MIME types to those listed above
// add an array for each instance of the MIME types you want changing
$c_node['file']['mime']['browser_path'] =			array(array("from" => "image/pjpeg", "to" => "image/jpeg"));
//filepaths
$c_node['file']['image']['path']['user'] = 			"user/";
$c_node['file']['image']['path']['group'] = 		"group/";


// MESSAGING CONFIGURATION ----------------------------------------------
$c_node['messaging']['message_box_max_size'] = 		"100000";
$c_node['messaging']['message_in_box'] = 			"1";
$c_node['messaging']['message_out_box'] = 			"2";
$c_node['messaging']['message_save_box'] = 			"3";
$c_node['messaging']['message_status_unread'] = 	"1";
$c_node['messaging']['message_status_read'] = 		"2";



// RPS CONFIGURATION ----------------------------------------------------

// group default (if auto register they get this level by default
$c_node['rsp']['group']['default'] = 				"12";
// zero = needs editorial approval, 1 = auto publish to splash
$c_node['rsp']['node']['auto_publish'] = 			"1";

// content types (you will still need to edit DB queries in rsp class if appending this)
$c_node['rsp']['item_type']['blog'] = 				"1";
$c_node['rsp']['item_type']['library'] = 			"2";
$c_node['rsp']['item_type']['file'] = 				"3";
$c_node['rsp']['item_type']['schedule'] = 			"4";
$c_node['rsp']['item_type']['forum'] = 				"5";
$c_node['rsp']['item_type']['poll'] = 				"6";
$c_node['rsp']['item_type']['channel'] = 			"7";
$c_node['rsp']['item_type']['network'] = 			"8";
$c_node['rsp']['item_type']['group'] = 				"9";
// rsp content status's
$c_node['rsp']['status']['live'] = 					"3";
$c_node['rsp']['status']['hold'] = 					"2";
$c_node['rsp']['status']['pending'] = 				"1";
// no of days to display content historically (increase on less busy installs)
$c_node['rsp']['publishing']['most_read'] = 		"14";
//Abuse report default level ID from an unallocated abuse report
$c_node['rsp']['abuse_status']['unallocated'] = 	"2";
//we have a rsp for both the node and the group (home page)
$c_node['rsp']['rsp_level']['public'] = 			"64";
$c_node['rsp']['rsp_level']['node'] = 				"32";
$c_node['rsp']['rsp_level']['degree'] = 			"16";
$c_node['rsp']['rsp_level']['group']['home'] = 		"4";
// user levels - we only publish to 4 degrees -
// above that is regarded as for everyone - see social network section


// USER CONFIGURATION --------------------------------------------------
$c_node['statistic']['user']['total_logins'] = 						"1";
$c_node['statistic']['user']['total_blogs'] = 						"2";
$c_node['statistic']['user']['total_shouts'] = 						"3";
$c_node['statistic']['user']['total_polls'] = 						"4";
$c_node['statistic']['user']['total_library_items'] = 				"5";
$c_node['statistic']['user']['total_forum_subjects'] = 				"6";
$c_node['statistic']['user']['total_comments'] = 					"7";
$c_node['statistic']['user']['total_votes'] = 						"8";

$c_node['statistic']['group']['total_members'] = 					"101";
$c_node['statistic']['group']['total_forum_subjects'] = 			"102";
$c_node['statistic']['group']['total_comments'] = 					"103";
$c_node['statistic']['group']['total_library_items'] = 				"104";
$c_node['statistic']['group']['total_polls'] = 						"105";
$c_node['statistic']['group']['total_blogs'] = 						"106";

$c_node['statistic']['group_member']['total_blogs'] = 				"301";
$c_node['statistic']['group_member']['total_comments'] = 			"302";
$c_node['statistic']['group_member']['total_forum_subjects'] = 		"303";
$c_node['statistic']['group_member']['total_library_items'] = 		"304";
$c_node['statistic']['group_member']['total_polls'] = 				"305";



// USER CONFIGURATION --------------------------------------------------
// relationship type
$c_node['user']['relation_type']['approved'] = 						"2";
$c_node['user']['relation_type']['approval_pending'] = 				"1";
// user status (pending means they have registered by not setup)
$c_node['user']['status']['inactive'] = 							"1";
$c_node['user']['status']['hold'] = 								"2";
$c_node['user']['status']['pending'] = 								"3";
$c_node['user']['status']['active'] = 								"4";



// GROUP CONFIGURATION --------------------------------------------------
// member statistics
// registration types
$c_node['group']['registration_type']['automatic'] = 				"1";
$c_node['group']['registration_type']['approved'] = 				"2";
$c_node['group']['registration_type']['closed'] = 					"3";
// member status
$c_node['group']['member_status']['barred'] = 						"1";
$c_node['group']['member_status']['pending'] = 						"2";
$c_node['group']['member_status']['active'] = 						"3";
// group status
$c_node['group']['status']['inactive'] = 							"1";
$c_node['group']['status']['hold'] = 								"2";
$c_node['group']['status']['pending'] = 							"3";
$c_node['group']['status']['active'] = 								"4";
// if you allow auto approval anyone can set up a group in this node
// without your permission. If you do not, anyone with the "group admin"
// ACS permission will receive a message asking them to review the application
// allow = "1" / deny = "0"
$c_node['group_setup']['allow_auto_visible_approval'] = 			"1";
$c_node['group_setup']['allow_auto_hidden_approval'] = 				"1";
// group categories


// SCHEDULE CONFIGURATION ---------------------------------------------------
// schedule = events and tasks
$c_node['schedule']['type']['event'] = 								"1";
$c_node['schedule']['type']['task'] = 								"2";

$c_node['schedule']['allocation_status']['pending'] = 				"1";
$c_node['schedule']['allocation_status']['confirmed'] = 			"2";
$c_node['schedule']['allocation_status']['rejected'] = 				"3";
$c_node['schedule']['allocation_status']['withdrawn'] = 			"4";

$c_node['schedule']['occurrence']['no_repeat'] = 					"0";
$c_node['schedule']['occurrence']['daily'] = 						"1";
$c_node['schedule']['occurrence']['weekly'] = 						"3";
$c_node['schedule']['occurrence']['monthly'] = 						"9";
$c_node['schedule']['occurrence']['yearly'] = 						"12";

$c_node['schedule']['status']['tentative'] = 						"1";
$c_node['schedule']['status']['confirmed'] = 						"2";
$c_node['schedule']['status']['cancelled'] = 						"3";


// BOOKMARK CONFIGURATION ---------------------------------------------------
$c_node['bookmark']['type']['watch'] = 								"1";
$c_node['bookmark']['type']['recommend'] = 							"2";


// SOCIAL NETWORK CONFIGURATION --------------------------------------------
$c_node['sn']['degree']['one'] = 					"1"; // friends (default)
$c_node['sn']['degree']['two'] = 					"2";  // two degrees
$c_node['sn']['degree']['three'] = 					"3";  // three degrees
$c_node['sn']['degree']['four'] = 					"4";  // four degrees

$c_node['sn']['max_degree'] = 						"4";  // four degrees



// MODULE --------------------------------------------------------------
$c_node['arr_section']['user'] = 									"1";
$c_node['arr_section']['group'] = 									"2";

// END OF FILE ----------------------------------------------------------
?>
