<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include "inc/header_group.inc.php";

//ACS check
if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group']['administration'], $c_acs['arr_acs']['privilege']['allow_tag'])) { //resourece_id, Priv_id
	header("Location: grp_view.php?group_id=" . $output_group['group_id'] . "&" . strip_tags(SID));
	exit;
}

// SETUP TAGS
require_once('class/Tag.class.php');
$tag = new Tag($db, null);
$tag->rsp_item_type_id = $c_node['rsp']['item_type']['group'];
$tag->level_id = $c_node['tag']['level']['recommended'];
$tag->group_id = $output_group['group_id'];

// PROCESS FORM ----------------------------------------------------------
if (isset($_POST['update_schedule_tag'])) {
	$del_arr = explode(',', $frmdata['tags']);
	$del_arr = array_unique($del_arr); //remove duplicates
		
	$tag->deleteTags($del_arr);
	
	$tag->user_id = $me['user_id'];
	$tag->insertTags($frmdata);
	
	return header("Location: node_tags.php?" . strip_tags(SID));
	exit;
}


//group categorisation tags (meta tags)
unset($tag->rsp_item_type_ids, $tag->user_id);
$output_group_meta_tags = $tag->selTags();

//group tags in usage
unset($tag->level_id);
$output_group_tags = $tag->selTags(1);


//move to template
if (!empty($output_group_tags)) {
	$body->set('group_tags', $output_group_tags);
}

if (!empty($output_group_meta_tags)) {
	$body->set('group_meta_tags', $output_group_meta_tags);
}


$template_pageLink = $lang['txt_group_tags'];
include "inc/footer.inc.php";

?>
