<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
?>

<div class="col_main">
	<div class="box">
		<div class="box_top">
			<?php
			if (isset($newsletter)) {
				echo $this->date->formatDate($newsletter['message_create_datetime'], 1);
			}
			else {
				echo $lang['hdr_newsletters'];
			}
			?>
			<br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($newsletter)) {
				?>
				<p class="txt_item_title">
					<?php echo $newsletter['message_subject'];?><br />
				</p>
				
				<p>
				<?php echo $newsletter['message_body'];?><br />
				</p>
				<?php
				}
				elseif (isset($newsletters)) { //list view
				?>
				
				<table width="100%" cellpadding="4" cellspacing="0" border="0">
					<?php
					$display_items = trimArray($newsletters);
					foreach($display_items as $key => $i):
					?>
					<tr>
						<td>
							<a href="nlt_view.php?message_id=<?php echo $i['message_id'];?>"><?php echo $i['message_subject'];?></a><br />
						</td>
						<td>
							<?php echo $i['status_id'];?><br />
						</td
					</tr>
					<?php
					endforeach;
					?>
				</table>
				<?php
				echo createArrayList($newsletters);
				?>
				<?php
				}
				else  { //error - no newsletters
					echo $lang['err_no_newsletters'] . "<br />";
				}?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>

<div class="col_side">
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_options'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($group) && $this->group_acs->checkPermission($resource_ids['group']['administration'], $privilege_ids['allow_newsletter'])) { //resourece_id, Priv_id
				if (isset($newsletter)) {
				?>
				<a href="nlt_view.php?group_id=<?php echo $group['group_id'];?>"><?php echo $lang['href_list_group'];?></a><br />
				<a href="nlt_edit.php?message_id=<?php echo $newsletter['message_id'];?>"><?php echo $lang['href_edit'];?></a><br />
				<?php }?>
				<a href="nlt_edit.php?group_id=<?php echo $group['group_id'];?>"><?php echo $lang['href_add_group_newsletter'];?></a><br />
				<?php
				}
				elseif ($this->user_acs->checkPermission($resource_ids['node']['administration'], $privilege_ids['allow_newsletter'])) { //resourece_id, Priv_id
				if (isset($newsletter)) {
				?>
				<a href="nlt_view.php"><?php echo $lang['href_list'];?></a><br />
				<a href="nlt_edit.php?message_id=<?php echo $newsletter['message_id'];?>"><?php echo $lang['href_edit'];?></a><br />
				<?php }?>
				<a href="nlt_edit.php"><?php echo $lang['href_add_newsletter'];?></a><br />
				<?php }?>
				
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	</form>
</div>
