<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include "inc/header_group.inc.php";


// SETUP LANGUAGE --------------------------------------------------------
require_once($languagePath . 'common.lang.php');
require_once($languagePath . 'grp_common.lang.php');
require_once($languageArrayPath . 'arr_user.lang.php');
require_once($languageArrayPath . 'arr_language_name.lang.php');


// PROCESS FORM ---------------------------------------------------------
// set the membership
if (isset($_POST['user_pending'])) {
	unset($group_acs->role_id);
	$role_default = $group_acs->getGroupRole(1);
	$group->member_status_id = $c_node['group']['member_status']['pending'];
	$group->insertMembership($frmdata['profile_id'], $role_default['role_id']);
	
	//get members with a priviledge of "edit" set against the resource "group membership"
	$group_roles = $group_acs->getGroupRoles();
	if (!empty($group_roles)) {
	    foreach($group_roles as $i):
			if($group_acs->getPermission($i['role_id'], $c_acs['arr_acs']['resource']['group']['administration'], $c_acs['arr_acs']['privilege']['allow_edit'])) {
				$group_roles_membership_edit[] = $i['role_id'];
			}
		endforeach;
	}
	$group->role_ids = $group_roles_membership_edit;
	$members_with_edit = $group->getMembers();
	
	//send IM to admin about application
	$body_txt = readTxtFile($languageTextPath . "im_group_membership_apply.txt.php");
	$body_txt = str_replace("SYS_KEYWORD_GROUP_ID", $group_id, $body_txt);
	
	if (!empty($members_with_edit)) {
	    foreach($members_with_edit as $i):
			$im->sendMessage($i['user_id'], $lang['txt_apply_im_subject'], $body_txt);
		endforeach;
	}
	
	header("Location: grp_membership.php?group_id=" . $group_id . "&" . strip_tags(SID));
	exit;
}
elseif (isset($_POST['user_member'])) {
	unset($group_acs->role_id);
	$role_default = $group_acs->getGroupRole(1);
	$group->member_status_id = $c_node['group']['member_status']['active'];
	$group->insertMembership($frmdata['profile_id'], $role_default['role_id']);
	
	//setup statistics
	require_once('class/Statistic.class.php');
	$statistic = new Statistic($db);
	$statistic->section_item_id = $group_id;
	$statistic->statistic_type_id = $c_node['statistic']['group']['total_members'];
	//reset the statistics
	$total_active_members = $group->getCountMembers();
	$statistic->setStatistic($total_active_members);
	
	header("Location: grp_view.php?group_id=" . $frmdata['group_id'] . strip_tags(SID));
	exit;
}
elseif (isset($_POST['update_membership'])) {
	$group->updateMembership($frmdata);
	
	if (empty($GLOBALS['am_error_log'])) {
		header("Location: grp_membership.php?group_id=" . $frmdata['group_id'] . "&user_id=" . $frmdata['user_id'] . "&" . strip_tags(SID));
		exit;
	}
}
elseif (isset($_POST['delete_membership_confirm'])) {
	$group->deleteMembership();
	header("Location: grp_view.php?". strip_tags(SID));
	exit;
}
elseif (isset($_POST['delete_membership'])) {
	$display_confirmation_delete = 1;
	
	$display = "show_group";
}


// SETUP WIKI -----------------------------------------------------------
require_once('class/Wiki/Wiki.php');
$wiki = new Text_Wiki();
$wiki->disableRule('freelink');
$wiki->disableRule('wikilink');
$wiki->setRenderConf('xhtml', 'image', 'base', 'get_file.php?file=');


// ----------------------------------------------------------------------
// if user is a member we display membership profile
// else if logged in we display membership apply form
// else we ask visitor to log in first

if (!empty($output_group['member']['user_id']) && ($output_group['member']['status_id'] == $c_node['group']['member_status']['active'])) {
	// is it another user?
	if (isset($_REQUEST['user_id'])) {
		$group->user_id = $_REQUEST['user_id'];
		
		$output_member = $group->getGroupMembership();
		
		if (isset($output_member['status_id']) && $output_member['status_id'] == $c_node['group']['member_status']['active']) {
			$output_group['member'] = $output_member;
			unset($output_member);
		}
	}
	
	
	//ACS check - can we edit this user?
	if ($group_acs->checkPermission($c_acs['arr_acs']['resource']['group']['administration'], $c_acs['arr_acs']['privilege']['edit_membership'])) { //resourece_id, Priv_id
		//get group roles
		$group_acs->group_id = $group_id;
		$group_roles = $group_acs->getGroupRoles();
		
		if (isset($output_member)) { // regardless of active status or not
			$output_group['member'] = $output_member;
		}
	}
	
	
	//setup file
	$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
	$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
	
	//get user and profile from membership
	$user->user_id = $output_group['member']['user_id'];
	$output_profile = $user->selProfile($output_group['member']['profile_id']);
	
	//setup blog
	require_once('class/Blog.class.php');
	$blog = new Blog($db, null, $file);
	$blog->group_id = $group_id;
	$blog->user_id = $output_group['member']['user_id'];
	$blog->limit = 5;
	$output_blogs = $blog->selBlogs();
	
	//setup forum
	require_once('class/Forum.class.php');
	$forum = new Forum($db, null, $file);
	$forum->group_id = $group_id;
	$forum->limit = 5;
	$forum->user_id = $output_group['member']['user_id'];
	$output_subjects = $forum->selSubjects();
	//$output_replies = $forum->getRepliesByUser();
	
	//setup comment
	require_once('class/Comment.class.php');
	$comment = new Comment($db, $c_node['rsp']['item_type']['blog']);
	$comment->group_id = $group_id;
	$comment->user_id = $output_group['member']['user_id'];
	$comment->limit = 10;
	$output_comments = $comment->selComments();
	
	//library setup
	require_once('class/Library.class.php');
	$library = new Library($db, null, $file);
	$library->section_item_id = $group_id;
	$library->user_id = $output_group['member']['user_id'];
	$library->limit = 5;
	$output_library = $library->selLibraryItems();
	
	//setup statistics
	require_once('class/Statistic.class.php');
	$statistic = new Statistic($db);
	$statistic->group_id = $group_id;
	$statistic->user_id = $output_group['member']['user_id'];
	$output_statistics = $statistic->getStatistics();
	
	//setup file
	$file->noimage = $c_node['file']['image']['thumb'][1]['noimage'];
	$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
	if (isset($output_profile['file_id'])) {
		$file->file_id = $output_profile['file_id'];
		$output_profile['image'] = $file->getFileRecord();
	}
	elseif (isset($output_profile)) {
		$output_profile['image']['file_title'] = "";
		$output_profile['image']['file'] = $file->noimage;
	}
	
	$output_profile['profile_summary'] = $wiki->transform($output_profile['profile_summary'], 'Xhtml');
	
	//get profiles
	unset($user->file);
	$output_profiles = $user->selProfiles();
	

	//display if this person is blocked
	if (isset($_REQUEST['user_id'])) {
		require_once('class/SocialNetwork.class.php');
		$sn = new Socialnetwork($me['user_id'], $db);
	
		if ($sn->getBlockStatus($_REQUEST['user_id'])) {
			$display = "blocked";
		}
	}
	
	$display = "member";
}
elseif (!empty($me['user_id'])) {
	// apply for membership
	//check the group status is active
	if ($output_group['status_id'] == $c_node['group']['status']['active']) {
		
		//append language setup
		require_once($languageArrayPath . 'arr_group.lang.php');
	
	
		//check the group members status
		if (isset($output_group['member']['status_id']) && $output_group['member']['status_id'] == $c_node['group']['member_status']['pending']) {
			$display_join = "group_application_in_progress";
			
		}
		elseif (isset($output_group['member']['status_id']) && $output_group['member']['status_id'] == $c_node['group']['member_status']['active']) {
			header("Location: g_group.php?group_id=" . $group_id . "&" . strip_tags(SID));
			exit;
		}
		elseif (empty($output_group['member']['status_id'])) {
			
			if ($output_group['group_visibility'] == 1) { //check if the group is not hidden
				//check the registration type
				if ($output_group['group_registration_type'] == $c_node['group']['registration_type']['automatic']) {
					$display_join = "group_apply_automatic";
				}
				elseif ($output_group['group_registration_type'] == $c_node['group']['registration_type']['approved']) {
					$display_join = "group_apply_approved";
				}
			}
		}
	} // if we end up with no $display set we will display a polite "group unavailable" message
	
		  
	unset($user->file);
	$user->user_id = $me['user_id'];
	$output_profiles = $user->selProfiles();
	
	
	$lang['txt_node_rules'] = readTxtFile($languageTextPath . 'node_rules.txt.php');
	$lang['txt_node_rules'] = stripslashes($lang['txt_node_rules']);
	$lang['txt_node_rules'] = $wiki->transform($lang['txt_node_rules'], 'Xhtml');
		
	$display = "apply";
}
else { // not logged in
	$display = "login";
}



//move to template
if (!empty($display_confirmation_delete)) {
	$body->set('display_confirmation_delete', $display_confirmation_delete);
}

if (!empty($output_profiles)) {
   $body->set('profiles', $output_profiles);
}

if (!empty($output_group)) {
	$body->set('group', $output_group);
	$tpl->set('group', $output_group);
}

if (!empty($output_profile)) {
	$body->set('profile', $output_profile);
}

if (!empty($output_group['member'])) {
	$body->set('member', $output_group['member']);
}

if (!empty($output_library)) {
	$body->set('library', $output_library);
}

if (!empty($output_blogs)) {
	$body->set('blogs', $output_blogs);
}

if (!empty($output_subjects)) {
	$body->set('subjects', $output_subjects);
}

if (!empty($output_comments)) {
	$body->set('comments', $output_comments);
}

if (!empty($output_statistics)) {
	$body->set('gm_statistics', $output_statistics);
}

if (isset($output_statistic)) {
	$body->set('group_statistic', $output_statistic);
}

if (!empty($group_roles)) {
	$body->set('group_roles', $group_roles);
}

$body->set('group_member_status_ids', $c_node['group']['member_status']);

if (!empty($display)) {
	$body->set('display', $display);
}

if (!empty($display_join)) {
	$body->set('display_join', $display_join);
}

if (!empty($output_group['member']['profile_nic'])) {
	$lang['nav_breadcrumb_note'] = $output_group['member']['profile_nic'];
}

include "inc/footer.inc.php";

?>
