<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "structure";


if (!isset($_REQUEST['contact_id'])) {
	header("Location: index.php?" . strip_tags(SID));
	exit;
}

if (isset($_POST['update_contact'])) {
	updateContactReport($_POST);
}

$output_contact_report = selContactReport($_REQUEST['contact_id']);

if (isset($output_contact_report)) {
	$body->set('contact_report', $output_contact_report);
	
	if (!empty($output_contact_report['reportee_user_id'])) {
		// get reporter
		require_once ("class/File.class.php");
		$file = new File($db, $core_config['file']);
		$file->user_id = $_SESSION['user_id'];
		$file->module_id = 0; // core
		$file->directory = "core";
		
		$user->file = $file;
		$user->file->no_image = $core_config['file']['image']['thumb'][1]['no_image'];
		$output_identity = $user->selUserIdentity($output_contact_report['reportee_user_id'], null, 1);
	
		$body->set('identity', $output_identity);
	}
	else {
		$lang['email_contact_report'] = str_replace("SYS_KEYWORD_EMAIL", $output_contact_report['reportee_email'], $lang['email_contact_report']);
	}
	
	$output_maintainers = selMaintainers();
	$body->set('maintainers', $output_maintainers);

}


/*
* selContactReport
* Tom Calthrop 29th September 2006
*/
function selContactReport($contact_id) {
	
	global $db;
	
	$query = "
		SELECT contact_id, reportee_user_id, contact_report_type, 
		reportee_language_id, report_datetime, report_status_id, 
		reportee_email, contact_message, contact_source, 
		contact_url, assigned_user_id 
		FROM " . $db->prefix . "_contact 
		WHERE
		contact_id=" . $contact_id
	;
	
	$result = $db->SelectLimit($query, 1); //returns last 1 rows
	
	if (isset($result->fields)) {
		
		$temp = $result->fields;
		
		return $temp;
	}
}


/*
* selMaintainers
* Tom Calthrop 29th September 2006
*/
function selMaintainers() {
	
	global $db, $core_config, $user;
	
	require_once('class/User.class.php');
	$user = new User($db, $core_config['user']);
		
	$query = "
		SELECT user_id, user_core_permission  
		FROM " . $db->prefix . "_user 
		WHERE
		user_core_permission>0"
	;
	
	$result = $db->Execute($query);
	
	if (isset($result->fields)) {
		
		unset ($user->user_ids);
		while (!$result->EOF) {
			if($result->fields['user_core_permission'] & $core_config['resource']['user']['mng_contacts']) {
				$user->user_ids[] = $result->fields['user_id'];
			}
			
			$result->MoveNext();
		}
	}
	
	// GET IDENTITIES FOR EACH MAINTAINER
	if (!empty($user->user_ids)) {	
		require_once ("class/File.class.php");
		$file = new File($db, $core_config['file']);
		$file->module_id = 0; // core
		$file->directory = "core";
		
		$user->file = $file;
		$user->file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
		
		$user->identity_type = $core_config['user']['identity']['type']['registered'];
		
		
		$user->order_by = "i.identity_type desc";
		
		return $user->selUserIdentities();
	}
}


/*
* updateContactReport
* Tom Calthrop 29th September 2006
*/
function updateContactReport($data) {
	
	global $db;
	
	$query = "
		SELECT contact_id, report_status_id, assigned_user_id 
		FROM " . $db->prefix . "_contact 
		WHERE
		contact_id=" . $data['contact_id']
	;
	
	$result = $db->SelectLimit($query, 1); //returns last 1 rows
	
	if (!isset($data['assigned_user_id']) || $data['assigned_user_id'] < 1) {
		$data['assigned_user_id'] = "null";
	}
	
	if (isset($result->fields)) {
		
		$rec = array();
		$rec['report_status_id'] =  $data['report_status_id'];
		$rec['assigned_user_id'] =  $data['assigned_user_id'];
		
		$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $db->Execute($query);
	}
}

?>