<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "structure";


// Permission check
if ($_SESSION['user_core_permission'] & $core_config['resource']['user']['permissions']) {
	
	// setup useradmin (extends user)
	require_once('class/User.class.php');
	require_once('class/UserAdmin.class.php');
	$user = new UserAdmin($db, $core_config['user']);
	
	if(isset($_POST['update_permissions'])) {
		
		$old_permissions = $user->selRolePermissions($_POST['role_id']);
		
		$user->deletePermissions($_POST['role_id']); // Resets all the permissions
		
		// set default user permissions
		if (!empty($_POST['permission'])) {
			$data['role_id'] = $_POST['role_id'];
			$data['role_core_permission'] = "0";
			
			if (!empty($_POST['permission']['user'])) {
				foreach ($_POST['permission']['user'] as $userresval => $rv):
					$data['role_core_permission'] = $data['role_core_permission']+$rv;
				endforeach;
			}
			
			$data['role_mod_permission'] = 0;
			
			if (!empty($_POST['permission']['mod'])) {
				foreach ($_POST['permission']['mod'] as $modresval => $rv):
					$data['role_mod_permission'] = $data['role_mod_permission']+$rv;
				endforeach;
			}
			
			$user->insertPermission($data);
		}
		
		
		if (isset($_POST['update_type']) && $_POST['update_type'] == "permission") {
			// do we need to update all users with role X to permission Y where permission is default
			$query = "
				SELECT user_id, user_core_permission, user_mod_permission 
				FROM " . $db->prefix . "_user 
				WHERE 
				role_id=" .$old_permissions[0]['role_id'] . " AND 
				user_core_permission=" .$old_permissions[0]['role_core_permission'] . " AND 
				user_mod_permission=" .$old_permissions[0]['role_mod_permission']
			;
			
			$result = $db->Execute($query);
				
			if (isset($result->fields)) {
				$rec = array();
				$rec['user_core_permission'] = $data['role_core_permission'];
				$rec['user_mod_permission'] = $data['role_mod_permission'];
			
				$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
				$result = $db->Execute($query);
			}
		}
		elseif (isset($_POST['update_type']) && $_POST['update_type'] == "role") {
			//	do we need to update all users to with role X to permission Y
			$query = "
				SELECT user_id, user_core_permission, user_mod_permission 
				FROM " . $db->prefix . "_user 
				WHERE 
				role_id=" .$old_permissions[0]['role_id']
			;
			
			$result = $db->Execute($query);
				
			if (isset($result->fields)) {
				$rec = array();
				$rec['user_core_permission'] = $data['role_core_permission'];
				$rec['user_mod_permission'] = $data['role_mod_permission'];
			
				$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
				$result = $db->Execute($query);
			}
			
			if ($_SESSION['role_id'] == $old_permissions[0]['role_id']) {
				$_SESSION['user_core_permission'] = $data['role_core_permission'];
				$_SESSION['user_mod_permission'] = $data['role_mod_permission'];
			}
		}
		
	}
	
	if (isset($_POST['view_role_id'])) {
		$role_id = $_POST['view_role_id'];
	}
	else {
		$role_id = $_SESSION['role_id'];
	}
	
	$body->set('role_id', $role_id);
	
	
	//RESOURCES
	$body->set('user_resources', $core_config['resource']['user']);
	
	if (!empty($core_config['resource']['module'])) {
		$body->set('module_resources', $core_config['resource']['module']);
	}
	
	
	// RESOURCE SETTINGS
	$output_permissions = $user->selRolePermissions();
	$body->set('permissions', $output_permissions);
	
	
	// USERS WITH ROLE
	$query = "
		SELECT count(user_id) as total
		FROM " . $db->prefix . "_user 
		WHERE
		role_id=" . $role_id
	;
		
	$result = $db->Execute($query);
		
	if (isset($result->fields)) {
		$lang['txt_people_role'] = str_replace("SYS_KEYWORD_TOTAL", $result->fields['total'], $lang['txt_people_role']);
	}
}
else {
	header("Location: index.php?amn=" . $_SESSION['user_homepage'] . "&" . strip_tags(SID));
	exit;
}


?>