<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include dirname(__FILE__) . "/../components/core/config/aroundme_core.config.php";
include "config/batch.config.php";


// SETUP DATABASE --------------------------------------------------------
require_once(dirname(__FILE__) . '/../components/core/class/Adodb/adodb.inc.php');
$ADODB_CACHE_DIR = 'cache/Adodb';
$ADODB_FETCH_MODE = ADODB_FETCH_BOTH;
$db = NewADOConnection($core_config['db']['driver']);
if ($db->Connect($core_config['db']['host'], $core_config['db']['user'] , $core_config['db']['pass'] , $core_config['db']['db'])) {
	$db->prefix = $core_config['db']['prefix'];
	
	$chart           = ImageCreate($batch_config['people_by_location']['width'], $batch_config['people_by_location']['height']);
	$backgroundcolor = ImageColorAllocate($chart, $batch_config['people_by_location']['color']['grids_background']['red'], $batch_config['people_by_location']['color']['grids_background']['green'], $batch_config['people_by_location']['color']['grids_background']['blue']);
	$gridscolor      = ImageColorAllocate($chart, $batch_config['people_by_location']['color']['grids']['red'], $batch_config['people_by_location']['color']['grids']['green'], $batch_config['people_by_location']['color']['grids']['blue']);
	$gridscolor_bg   = ImageColorAllocate($chart, $batch_config['people_by_location']['color']['grids_background']['red'], $batch_config['people_by_location']['color']['grids_background']['green'], $batch_config['people_by_location']['color']['grids_background']['blue']);
	$foregroundcolor = ImageColorAllocate($chart, $batch_config['people_by_location']['color']['foreground']['red'], $batch_config['people_by_location']['color']['foreground']['green'], $batch_config['people_by_location']['color']['foreground']['blue']);
	$foregroundcolor2= ImageColorAllocate($chart, $batch_config['people_by_location']['color']['foreground2']['red'], $batch_config['people_by_location']['color']['foreground2']['green'], $batch_config['people_by_location']['color']['foreground2']['blue']);
	$chart_bg = ImageColorAllocate($chart, $batch_config['people_by_location']['color']['background']['red'], $batch_config['people_by_location']['color']['background']['green'], $batch_config['people_by_location']['color']['background']['blue']);
	$y_values        = array();
	
	
	// selecting values from the database -----------------------------------------------------
	$query = "
		SELECT l.location_name, count(l.location_id) as count_location 
		FROM " . $db->prefix . "_user u 
		INNER JOIN " . $db->prefix . "_user_location l 
		ON u.location_id=l.location_id 
		GROUP BY l.location_id 
		ORDER BY count_location DESC"
	;
	
	$result = $db->Execute($query);
	$counter = 0;
			
	if (isset($result)) {
		while(!$result->EOF && $counter < 20) {
			$y_values[] = $result->fields;
			$counter++;
			$result->moveNext();
		}
		$result->Close();
	}
	
	$n = isset($y_values[0]) ? ceil(intval($y_values[0]['count_location'])/10)*10 : 1;
	$r = ($batch_config['people_by_location']['width'] - $batch_config['people_by_location']['padding']['left'] - $batch_config['people_by_location']['scale_factor'] * $batch_config['people_by_location']['width'])/$n;

	sort($y_values);
	
	if (count($y_values) != 0) {
		$space = intval($batch_config['people_by_location']['height']/ count($y_values));
	}
	else {
		$space = $batch_config['people_by_location']['height'];
	}
	
	imagefilledrectangle($chart, 0, 0, $batch_config['people_by_location']['width'], $batch_config['people_by_location']['height'] - 2*$batch_config['people_by_location']['padding']['bottom'], $chart_bg);
	
	// construct the chart --------------------------------------------------------------------
	for($i=0; $i < count($y_values); $i++) {
		$str = strlen($y_values[$i]['location_name']) > 16 ? substr($y_values[$i]['location_name'], 0, 16) . "..." : $y_values[$i]['location_name'];
		imagestring($chart, 2, $batch_config['people_by_location']['padding']['left'], $i*$space - 3 +$batch_config['people_by_location']['padding']['top'], $str, $gridscolor);
		imagefilledrectangle($chart, $batch_config['people_by_location']['width'] * $batch_config['people_by_location']['scale_factor'], $i*$space + $batch_config['people_by_location']['padding']['top'], $batch_config['people_by_location']['width'] - $batch_config['people_by_location']['padding']['right'], $i*$space + 3 +$batch_config['people_by_location']['padding']['top'], $foregroundcolor2);
		imagefilledrectangle($chart, $batch_config['people_by_location']['width'] * $batch_config['people_by_location']['scale_factor'], $i*$space + $batch_config['people_by_location']['padding']['top'], $batch_config['people_by_location']['width'] * $batch_config['people_by_location']['scale_factor']+ $r*$y_values[$i]['count_location'], $i*$space + 3 +$batch_config['people_by_location']['padding']['top'], $foregroundcolor);
	}
	
 	imageline($chart, $batch_config['people_by_location']['width'] * $batch_config['people_by_location']['scale_factor'], $batch_config['people_by_location']['height'] - 2*$batch_config['people_by_location']['padding']['top'], $batch_config['people_by_location']['width']- $batch_config['people_by_location']['padding']['right'], $batch_config['people_by_location']['height'] - 2*$batch_config['people_by_location']['padding']['top'], $gridscolor);
	imageline($chart, ($batch_config['people_by_location']['width'] * $batch_config['people_by_location']['scale_factor']), $batch_config['people_by_location']['height'] - 2*$batch_config['people_by_location']['padding']['top'], ($batch_config['people_by_location']['width'] * $batch_config['people_by_location']['scale_factor']), $batch_config['people_by_location']['height'] - 3 - 2*$batch_config['people_by_location']['padding']['top'], $gridscolor);
	imageline($chart, ((($batch_config['people_by_location']['width']- $batch_config['people_by_location']['padding']['right']) * $batch_config['people_by_location']['scale_factor']) + $batch_config['people_by_location']['width'])/2, $batch_config['people_by_location']['height'] - 2*$batch_config['people_by_location']['padding']['top'], ((($batch_config['people_by_location']['width']- $batch_config['people_by_location']['padding']['right']) * $batch_config['people_by_location']['scale_factor']) + $batch_config['people_by_location']['width'])/2, $batch_config['people_by_location']['height'] - 3 - 2*$batch_config['people_by_location']['padding']['top'], $gridscolor);
	imageline($chart, $batch_config['people_by_location']['width'] - $batch_config['people_by_location']['padding']['right'], $batch_config['people_by_location']['height'] - 2*$batch_config['people_by_location']['padding']['top'], $batch_config['people_by_location']['width'] - $batch_config['people_by_location']['padding']['right'], $batch_config['people_by_location']['height'] - 2*$batch_config['people_by_location']['padding']['top']-3, $gridscolor);
	
	imagestring($chart, 0, ($batch_config['people_by_location']['width'] * $batch_config['people_by_location']['scale_factor']), $batch_config['people_by_location']['height'] - 2*9, "0", $gridscolor);
 	imagestring($chart, 0, $batch_config['people_by_location']['width'] - 2*strlen($n) - $batch_config['people_by_location']['padding']['right'], $batch_config['people_by_location']['height'] - 2*9, $n, $gridscolor);
 	imagestring($chart, 0, ($batch_config['people_by_location']['width'] * $batch_config['people_by_location']['scale_factor'] + $batch_config['people_by_location']['width'])/2 - 5, $batch_config['people_by_location']['height'] - 2*9, $n/2, $gridscolor);
	
	
	imagestring($chart, 1, $batch_config['people_by_location']['padding']['left'], $batch_config['people_by_location']['height'] - $batch_config['people_by_location']['padding']['bottom'], date('Y-m-d h:i:s'), $gridscolor);
	imagepng($chart, $batch_config['people_by_location']['name']); 
	ImageDestroy($chart);
}

?>