<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "structure";


if ($_SESSION['user_core_permission'] & $core_config['resource']['user']['maintainer']) {
	
	//setup useradmin (extends user)
	require_once('class/User.class.php');
	require_once('class/UserAdmin.class.php');
	$user = new UserAdmin($db, $core_config['user']);
	
	
	if (isset($_REQUEST['sort'])) {
		switch($_REQUEST['sort']){
			case 'location_id':
				$user->order_by = "l.location_name";
				break;
			case 'user_id':
				$user->order_by = "u.user_id";
				break;
			case 'role_id':
				$user->order_by = "u.role_id";
				break;
			case 'user_firstname':
				$user->order_by = "u.user_firstname";
				break;
			case 'user_surname':
				$user->order_by = "u.user_surname";
				break;
			case 'user_create_datetime':
				$user->order_by = "u.user_create_datetime";
				break;
			case 'language_id':
				$user->order_by = "u.language_id";
				break;
			case 'status_id':
				$user->order_by = "u.status_id";
				break;
			default:
				$user->order_by = "u.user_firstname";
			}
	}
	else {
		$user->order_by = "u.user_firstname";
	}
		
	$output_users = $user->selUsers();
		
	$body->set('users', $output_users);
	
}
else {
	header("Location: index.php?" . strip_tags(SID));
	exit;
}
?>