<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "me";


require_once('class/User.class.php');
require_once('class/UserAdmin.class.php');
$user = new UserAdmin($db, $core_config);

if (isset($_POST['register'])) {
	// Checks the email and the password
	$catpcha = strtoupper($_POST['captchastring']);
	
	if (empty($catpcha) || empty($_SESSION['CAPTCHAString']) || $_SESSION['CAPTCHAString'] != $catpcha) {
		$GLOBALS['am_error_log'][] = array('captcha_wrong');
	}
	
	// Check the email
	if(empty($_POST['user_email'])) {
		$GLOBALS['am_error_log'][] = array('email_invalid');
	}
	else {
		if(!preg_match('/^[-A-Za-z0-9_.]+[@][A-Za-z0-9_-]+([.][A-Za-z0-9_-]+)*[.][A-Za-z]{2,8}$/', $_POST['user_email'])) {
			$GLOBALS['am_error_log'][] = array('email_invalid', $_POST['user_email']);
		}
		
		$query = "
			SELECT user_id FROM " . $db->prefix . "_user
			WHERE 
			user_email=" . $db->qstr($_POST['user_email'], get_magic_quotes_gpc())
		;
		
		$result = $db->Execute($query);

		if(!empty($result->fields['user_id'])) {
			$GLOBALS['am_error_log'][] = array('email_in_use', $_POST['user_email']);
		}
	}

	// Check the firstname
	if(empty($_POST['user_firstname'])) {
		$GLOBALS['am_error_log'][] = array('firstname_empty');
	}
	
	// Check the languages a user can read
	if(isset($_POST['language_ids']) && empty($_POST['language_ids'])) {
		$GLOBALS['am_error_log'][] = array('language_empty');
	}
	
	
	if (empty($GLOBALS['am_error_log'])) {
		//setup email
		require_once('class/Mail/class.phpmailer.php');
		$mail = new PHPMailer($core_config['mail']);
		
		$mail->AddReplyTo($core_config['mail']['no_reply_address'], $lang['subject_noreply']);
		$mail->Subject = $lang['subject_complete_registration'];
		
		$user->mail = $mail;
		
		$user->template_id = $core_config['template']['default_id'];
		$user->template_name = $core_config['template']['default_name'];
		$user->status_id = $core_config['user']['status']['pending'];
		$user->page_default = $core_config['node']['page_default'];
		$user->membership_type_default = $core_config['membership_type']['invite_default'];
		
		if (!isset($_POST['language_id'])) {
			$_POST['language_id'] = $core_config['language']['default_id'];
		}
		
		$user->registerUser($_POST);
		
		
		$body->set('display', "registration_complete");
		
	}
}
elseif (isset($_REQUEST['invitee']) && isset($_REQUEST['email']) && isset($_REQUEST['mod'])) {
	
	$query = "
		SELECT user_id, identity_id, module_id, item_id 
		FROM " . $db->prefix . "_user_invite 
		WHERE 
		user_id=" . $_REQUEST['invitee'] . " AND 
		module_id=" . $_REQUEST['mod'] . " AND 
		invited_email=" . $db->qstr($_REQUEST['email'], get_magic_quotes_gpc())
	;
	
	$result = $db->SelectLimit($query, 1); // just get the first invitee
		
	if (isset($result->fields)) {
		// INDENTITY
		require_once ("class/File.class.php");
		$file = new File($db, $core_config['file']);
		$file->module_id = 0; // core
		$file->directory = "core";
		
		$user->file = $file;
		$user->file->thumb = $core_config['file']['image']['thumb'][0]['suffix'];
		$user->file->no_image = $core_config['file']['image']['thumb'][0]['no_image'];
		
		if (isset($result->fields['identity_id'])) {
			$output_identity = $user->selUserIdentity(null, $result->fields['identity_id']);
		}
		else {
			$user->identity_type = $core_config['user']['identity']['type']['registered'];
			$output_identity = $user->selUserIdentity($result->fields['user_id']);
		}
		
		$body->set('identity', $output_identity);
	}
	
	$_POST['user_email'] = $_REQUEST['email'];
}

?>