<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


// if we receive a module_id and an item_id we display the stylesheet based upon that item

if (!isset($_SESSION['user_id']) || $_SESSION['user_id'] < 1) {
	header("Location: index.php?" . strip_tags(SID));
	exit;
}

$menu_section= "me";


// MODULE HEADER INCLUSION -----------------------------------------------
// We include any header files for the modules
if (empty($suffix)) {
	$suffix = "core";
}

if (is_file("components/" . $suffix . "/inc/" . $suffix . "_stylesheet_editor.inc.php")) {
	include_once("components/" . $suffix . "/inc/" . $suffix . "_stylesheet_editor.inc.php");
}


// we validate and save the stylesheet
if (isset($_POST['update'])) {
	
	// we parse the css into individual elements
	$css = renderStyleSheet($_POST['style']);
	
	// we save it
	$function_name = "setStyleSheet_" . $suffix;
	
	if (function_exists($function_name)) {
		$function_name($_REQUEST['item_id'], $css);
	}
}


// we get the stylesheet
$function_name = "selItem_" . $suffix;
			
if (function_exists($function_name)) {
	$output_item = $function_name($_REQUEST['item_id']);
}


if (!empty($allowable_styles) && !empty($output_item)) {
	$body->set('allowable_styles', $allowable_styles);
	$body->set('item', $output_item);
	
	// select files for dropdown
	require_once ("class/File.class.php");
	$file = new File($db, $core_config['file']);
	$file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
	
	if (isset($core_config['module'])) {
		$file->core_config_module = $core_config['module'];
	}
	
	$file->module_id = $module_id;
	$file->item_id = $output_item['item_id'];
	
	$output_images = $file->selFiles("images", "t2");
	
	if (!empty($output_images)) {
		$body->set("images", $output_images);
	}
	
	
	// include a language file that describes elements
	include_once($language_path . 'inc/stylesheet_edit.lang.inc.php');
}

$output_stylesheet_arr = parseStyleSheet($output_item['item_css']);

if (!empty($output_stylesheet_arr)) {
	$body->set("stylesheet_arr", $output_stylesheet_arr);
}


// parseStyleSheet
// takes a set css and parses it out as an array
function parseStyleSheet ($css) {

	global $allowable_styles;
	
	//echo $css;
	
	if (!empty($allowable_styles)) {
			
		$parsed_css = array();
			
		$css = trim($css);
			
		foreach ($allowable_styles as $keyelmt => $elmt):
			
			$elmt_preg_name = str_replace("#", "\#", $elmt['element']);
			
			$pattern = "/" . $elmt_preg_name . " {(.*?)\}/";
			
			if (preg_match($pattern, $css, $item_css)) {
				
				// we explode the styles for this element
				if (!empty($item_css[1])) {
					$styles = explode (";", $item_css[1]);
					
					// we go through out allowable styles and check against one from css
					foreach ($elmt['styles'] as $keyallowb => $allowb):
						
						foreach ($styles as $keystyl => $styl):
							$style = explode (":", $styl);
						
							// check the style is allowable
							if (!empty($style[1])) {
								
								$test_style = trim ($style[0]);
								$test_value = trim ($style[1]);
								
								if ($test_style == "background-image") {
									
									$pattern = '/file=1-(.*?)\)/'; // retrieves only md5
									
									if(preg_match($pattern, $test_value, $temp)) {
									
										$test_value = $temp[1];
									}
								}
								
								// remove any "px" information from end of value
								$pattern = '/(.*?)px/';
								
								if(preg_match($pattern, $test_value, $temp)) {
									
									$test_value = $temp[1];
								}
								
								if ($allowb == $test_style) {
									$parsed_css[$elmt['element']][$test_style] = $test_value;
									break;
								}
							}
						endforeach;
					endforeach;
				}
				
			}
		endforeach;
	}

	return $parsed_css;
}


// renderStyleSheet
// takes a set of form vars and parses them as a single css stylesheet
function renderStyleSheet ($properties) {
	$stylesheet = "";
	
	if (!empty($properties)) {
		foreach ($properties as $keyelmt => $i):
			if (!empty($i)) {
				
				$style = "";
				
				foreach ($i as $keystyl => $s):
					
					if ($keystyl == "color" && !empty($s)) {
						if(preg_match('/^#+[A-Za-z0-9]{6}$/', $s)) {
							$style .= "color:" . $s . ";";
						}
						else {
							$GLOBALS['am_error_log'][] = array('css_color_incorrect', $s);
						}
					}
					
					if ($keystyl == "background-color" && !empty($s)) {
						
						if(preg_match('/^#+[A-Za-z0-9]{6}$/', $s)) {
							$style .= "background-color:" . $s . ";";
						}
						else {
							$GLOBALS['am_error_log'][] = array('css_color_incorrect', $s);
						}
					}
					
					if ($keystyl == "background-image" && !empty($s)) {
						
						$url = "get_file.php?file=" . $s;
						$style .= "background-image: url(" . $url . ");";
					}
					
					if ($keystyl == "border-color" && !empty($s)) {
						if(preg_match('/^#+[A-Za-z0-9]{6}$/', $s)) {
							$style .= "border-color:" . $s . ";";
						}
						else {
							$GLOBALS['am_error_log'][] = array('css_color_incorrect', $s);
						}
					}
					
					if ($keystyl == "border-size" && !empty($s)) {
						if(preg_match('/^[0-9]{1,2}$/', $s)) {
							$style .= "border:solid " . $s . "px;";
						}
						else {
							$GLOBALS['am_error_log'][] = array('css_number_incorrect', $s);
						}
					}
					
					if ($keystyl == "text-size" && !empty($s)) {
						if(preg_match('/^[0-9]{1,3}$/', $s)) {
							$style .= "font-size:" . $s . "%;";
						}
						else {
							$GLOBALS['am_error_log'][] = array('css_number_incorrect', $s);
						}
					}
					
					if ($keystyl == "border-top" && !empty($s)) {
						if(preg_match('/^[0-9]{1,2}$/', $s)) {
							$style .= "border-top:" . $s. "px;";
						}
						else {
							$GLOBALS['am_error_log'][] = array('css_number_incorrect', $s);
						}
					}
					
					if ($keystyl == "border-left" && !empty($s)) {
						if(preg_match('/^[0-9]{1,2}$/', $s)) {
							$style .= "border-left:" . $s. "px;";
						}
						else {
							$GLOBALS['am_error_log'][] = array('css_number_incorrect', $s);
						}
					}
					
					if ($keystyl == "border-right" && !empty($s)) {
						if(preg_match('/^[0-9]{1,2}$/', $s)) {
							$style .= "border-right:" . $s. "px;";
						}
						else {
							$GLOBALS['am_error_log'][] = array('css_number_incorrect', $s);
						}
					}
					
					if ($keystyl == "border-bottom" && !empty($s)) {
						if(preg_match('/^[0-9]{1,2}$/', $s)) {
							$style .= "border-bottom:" . $s. "px;";
						}
						else {
							$GLOBALS['am_error_log'][] = array('css_number_incorrect', $s);
						}
					}
					
					if ($keystyl == "border-style" && !empty($s) && $s != "none") {
						$style .= "border-style:" . $s. ";";
					}
					
					if ($keystyl == "margin-top" && !empty($s)) {
						if(preg_match('/^[0-9]{1,2}$/', $s)) {
							$style .= "margin-top:" . $s. "px;";
						}
						else {
							$GLOBALS['am_error_log'][] = array('css_number_incorrect', $s);
						}
					}
					
					if ($keystyl == "margin-left" && !empty($s)) {
						if(preg_match('/^[0-9]{1,2}$/', $s)) {
							$style .= "margin-left:" . $s. "px;";
						}
						else {
							$GLOBALS['am_error_log'][] = array('css_number_incorrect', $s);
						}
					}
					
					if ($keystyl == "margin-right" && !empty($s)) {
						if(preg_match('/^[0-9]{1,2}$/', $s)) {
							$style .= "margin-right:" . $s. "px;";
						}
						else {
							$GLOBALS['am_error_log'][] = array('css_number_incorrect', $s);
						}
					}
					
					if ($keystyl == "margin-bottom" && !empty($s)) {
						if(preg_match('/^[0-9]{1,2}$/', $s)) {
							$style .= "margin-bottom:" . $s. "px;";
						}
						else {
							$GLOBALS['am_error_log'][] = array('css_number_incorrect', $s);
						}
					}
					
					if ($keystyl == "margin-style" && !empty($s) && $s != "none") {
						$style .= "margin-style:" . $s. ";";
					}
					
					if ($keystyl == "padding-top" && !empty($s)) {
						if(preg_match('/^[0-9]{1,2}$/', $s)) {
							$style .= "padding-top:" . $s. "px;";
						}
						else {
							$GLOBALS['am_error_log'][] = array('css_number_incorrect', $s);
						}
					}
					
					if ($keystyl == "padding-left" && !empty($s)) {
						if(preg_match('/^[0-9]{1,2}$/', $s)) {
							$style .= "padding-left:" . $s. "px;";
						}
						else {
							$GLOBALS['am_error_log'][] = array('css_number_incorrect', $s);
						}
					}
					
					if ($keystyl == "padding-right" && !empty($s)) {
						if(preg_match('/^[0-9]{1,2}$/', $s)) {
							$style .= "padding-right:" . $s. "px;";
						}
						else {
							$GLOBALS['am_error_log'][] = array('css_number_incorrect', $s);
						}
					}
					
					if ($keystyl == "padding-bottom" && !empty($s)) {
						if(preg_match('/^[0-9]{1,2}$/', $s)) {
							$style .= "padding-bottom:" . $s. "px;";
						}
						else {
							$GLOBALS['am_error_log'][] = array('css_number_incorrect', $s);
						}
					}
					
					if ($keystyl == "padding-style" && !empty($s) && $s != "none") {
						$style .= "padding-style:" . $s. ";";
					}
					
					if ($keystyl == "width" && !empty($s)) {
						if(preg_match('/^[0-9]{2,3}$/', $s)) {
							$style .= "width:" . $s . "px;";
						}
						else {
							$GLOBALS['am_error_log'][] = array('css_width_incorrect', $s);
						}
					}
					
					if ($keystyl == "float" && !empty($s)) {
						$style .= "float:" . $s . ";";
					}
					
				endforeach;
			
				if (!empty($style)) {
					$stylesheet .= $keyelmt . " {" . $style . "}\n";
				}
			}
		endforeach;
	}
	
	return $stylesheet;
}

?>