<h1>XHTML markup</h1>
XHTML stands for EXtensible HyperText Markup Language

<toc>XHTML help contents</toc>

<h3>address</h3>
<p>
	The &lt;address&gt; tag defines the start of an address. You should use it to define addresses, signatures, or authorships of documents.
</p>

<table class="ex" cellspacing="0" border="1" width="100%" cellpadding="3">
<tr>
  <th valign="top" align="left" width="40%">Source</th>
  <th valign="top" align="left" width="60%">Output</th>
</tr>
<tr>
	<td valign="top">
	&lt;address&gt;<br />
	My street&lt;br /&gt;<br />
	My town&lt;br /&gt;<br />
	&lt;/address&gt;
	</td>
	<td valign="top">
	<address>
	My street<br />
	My town<br />
	</address>
	</td>
</tr>
</table>


<h3>break</h3>
<p>
	The &lt; br /&gt; tag inserts a single line break. 
</p>

<table class="ex" cellspacing="0" border="1" width="100%" cellpadding="3">
<tr>
  <th valign="top" align="left" width="40%">Source</th>
  <th valign="top" align="left" width="60%">Output</th>
</tr>
<tr>
	<td valign="top">
		This text contains&lt;br /&gt;a line break<br />
	</td>
	<td valign="top">
		This text contains<br />a line break
	</td>
</tr>
</table>


<h3>code</h3>
<p>
	The &lt;code&gt; tag defines computer code text
</p>

<table class="ex" cellspacing="0" border="1" width="100%" cellpadding="3">
<tr>
  <th valign="top" align="left" width="40%">Source</th>
  <th valign="top" align="left" width="60%">Output</th>
</tr>
<tr>
	<td valign="top">
		s&lt;code&gt;Computer code texts&lt;/code&gt;s&lt;br /&gt;
	</td>
	<td valign="top">
		<code>Computer code text</code><br />
	</td>
</tr>
</table>


<h3>code</h3>
<p>
	The &lt;area&gt; tag defines a region in an image map.
</p>

<table class="ex" cellspacing="0" border="1" width="100%" cellpadding="3">
<tr>
  <th valign="top" align="left" width="40%">Source</th>
  <th valign="top" align="left" width="60%">Output</th>
</tr>
<tr>
	<td valign="top">&lt;p&gt;Click on one of the planets:&lt;/p&gt;
      <p>&lt;img src =&quot;planets.gif&quot;<br />
      width=&quot;145&quot; height=&quot;126&quot;<br />

      alt=&quot;Planets&quot;<br />
      usemap =&quot;#planetmap&quot; /&gt;<br />
      <br />
      &lt;map id =&quot;planetmap&quot;<br />
      name=&quot;planetmap&quot;&gt;<br />

      &nbsp;
      &lt;area shape =&quot;rect&quot; coords =&quot;0,0,82,126&quot;<br />
      &nbsp; href =&quot;sun.htm&quot; target =&quot;_blank&quot;<br />

      &nbsp; alt=&quot;Sun&quot; /&gt;<br />
      &nbsp;
      &lt;area shape =&quot;circle&quot; coords =&quot;90,58,3&quot;<br />
      &nbsp; href =&quot;mercur.htm&quot; target =&quot;_blank&quot;<br />

      &nbsp; alt=&quot;Mercury&quot; /&gt;<br />
      &nbsp;
      &lt;area shape =&quot;circle&quot; coords =&quot;124,58,8&quot;<br />
      &nbsp; href =&quot;venus.htm&quot; target =&quot;_blank&quot;<br />

      &nbsp; alt=&quot;Venus&quot; /&gt;<br />
      &lt;/map&gt;</p>
    </td>
    <td valign="top">
      <p>Click on one of the planets:</p>

      <img src="planets.gif" width="145" height="126" usemap="#planetmap" alt="Planets" />
      <map id="planetmap" name="planetmap">
      <area shape="rect" coords="0,0,82,126" href="sun.htm" target="_blank" alt="Sun"></area>
      <area shape="circle" coords="90,58,3" href="mercur.htm" target="_blank" alt="Mercury"></area>
      <area shape="circle" coords="124,58,8" href="venus.htm" target="_blank" alt="Venus"></area>
      </map>
    </td>
</tr>
</table>

<h4>Attributes</h4>

<table class="ex" cellspacing="0" border="1" width="100%" cellpadding="3">
  <tr>

    <th align="left" valign="top" width="15%">Attribute</th>
    <th align="left" valign="top" width="45%">Value</th>
    <th align="left" valign="top" width="35%">Description</th>
  </tr>
  <tr>
    <td valign="top">alt</td>

    <td valign="top">text</td>
    <td valign="top">Specifies an alternate text for the area</td>
  </tr>
 <tr>
    <td valign="top">coords</td>
    <td valign="top"><p>if shape=&quot;rect&quot; then<br />
    coords=&quot;left,top,right,bottom&quot;<p>if shape=&quot;circ&quot; then<br />

    coords=&quot;centerx,centery,radius&quot;</p>
    <p>if shape=&quot;poly&quot; then<br />
    coords=&quot;x1,y1,x2,y2,..,xn,yn&quot;</p></td>
    <td valign="top">Specifies the coordinates for the clickable area</td>
  </tr>
  <tr>
    <td valign="top">href</td>
    <td valign="top">URL</td>
    <td valign="top">Specifies the target URL of the area</td>

  </tr>
  <tr>
    <td valign="top">shape</td>
    <td valign="top">
      rect<br />
      rectangle<br />
    circ<br />

    circle<br />
    poly<br />
    polygon</td>
    <td valign="top">Defines the shape of the area</td>
  </tr>
</table>

<h3>a</h3>
<p>
	The &lt;a&gt; tag defines a region in an image map.<br />
	href, title, rel, rev, name
</p>


<h3>abbr</h3>
<p>
	The &lt;acronym&gt; tag defines a region in an image map.<br />
	title
</p>

<h3>b</h3>
<p>
	The &lt;b&gt; tag defines a region in an image map.<br />
	
</p>


<h3>base</h3>
<p>
	The &lt; base&gt; tag defines a region in an image map.<br />
	href
</p>


<h3> bdo </h3>
<p>
	The &lt bdo&gt; tag defines a region in an image map.<br />
	dir
</p>


<h3> big </h3>
<p>
	The &lt;big&gt; tag defines a region in an image map.<br />
	dir
</p>


<h3> blockquote </h3>
<p>
	The &lt; blockquote&gt; tag defines a region in an image map.<br />
	dir
</p>


<h3> col </h3>
<p>
	The &lt; col&gt; tag defines a region in an image map.<br />
	align, char, charoff, span, valign, width
</p>


<h3> del </h3>
<p>
	The &lt; del&gt; tag defines a region in an image map.<br />
	datetime
</p>


<h3> dd </h3>
<p>
	The &lt; dd&gt; tag defines a region in an image map.<br />
	
</p>


<h3> div </h3>
<p>
	The &lt; div&gt; tag defines a region in an image map.<br />
	aLIGN, CLASSS
</p>


<h3> dl </h3>
<p>
	The &lt; dl&gt; tag defines a region in an image map.<br />
	
</p>


<h3> dt </h3>
<p>
	The &lt; dt&gt; tag defines a region in an image map.<br />
	
</p>


<h3> em </h3>
<p>
	The &lt; em&gt; tag defines a region in an image map.<br />
	
</p>


<h3> embed </h3>
<p>
	The &lt; embed&gt; tag defines a region in an image map.<br />
	type, src, wmode, width, height
</p>


<h3> headers 1 to 6 </h3>
<p>
	The &lt; h1&gt; tag defines a region in an image map.<br />
	align
</p>


<h3> horizontal rule </h3>
<p>
	The &lt;hr /&gt; tag defines a region in an image map.<br />
	align, noshade, size, width
</p>


<h3>italic text</h3>
<p>
	The &lt;i&gt; tag defines a region in an image map.<br />
	align, noshade, size, width
</p>


<h3>img</h3>
<p>
	The &lt;img&gt; tag defines a region in an image map.<br />
	src, alt, align, border, height, hspace, vspace, width
</p>


<h3>ins</h3>
<p>
	The &lt;ins&gt; tag defines a region in an image map.<br />
	dattime, cite
</p>


<h3> kbd </h3>
<p>
	The &lt; kbd&gt; tag defines a region in an image map.<br />
	
</p>


<h3> li </h3>
<p>
	The &lt; li&gt; tag defines a region in an image map.<br />
	
</p>


<h3> object </h3>
<p>
	The &lt; object&gt; tag defines a region in an image map.<br />
	align, archive border, classid, codebase, daata, declare, height, hspace,  name, standby, type, usemap,vspace, width 
</p>


<h3> ol </h3>
<p>
	The &lt; ol&gt; tag defines a region in an image map.<br />
	compact, start type
</p>


<h3> p</h3>
<p>
	The &lt; p&gt; tag defines a region in an image map.<br />
	align
</p>


<h3> param</h3>
<p>
	The &lt; param&gt; tag defines a region in an image map.<br />
	name, type, value, valuetype
</p>


<h3> pre</h3>
<p>
	The &lt; pre&gt; tag defines a region in an image map.<br />
	width
</p>


<h3> q</h3>
<p>
	The &lt; q&gt; tag defines a region in an image map.<br />
	cite
</p>


<h3> span </h3>
<p>
	The &lt; span&gt; tag defines a region in an image map.<br />
	align, class
</p>


<h3> strike </h3>
<p>
	The &lt; strike&gt; tag defines a region in an image map.<br />
	align, class
</p>


<h3> strong </h3>
<p>
	The &lt; strong&gt; tag defines a region in an image map.<br />
	
</p>


<h3> sub </h3>
<p>
	The &lt; sub&gt; tag defines a region in an image map.<br />
	
</p>


<h3> sup </h3>
<p>
	The &lt; sup&gt; tag defines a region in an image map.<br />
	
</p>


<h3> table </h3>
<p>
	The &lt; table&gt; tag defines a region in an image map.<br />
	align, char, charoff, valign
</p>


<h3> tbody </h3>
<p>
	The &lt; tbody&gt; tag defines a region in an image map.<br />
	align, bgcolor, border, cellspacing, cellpadding, frame, ruls, summary, width, tbody, align, char, chaoff, colspan, headers, height, nowrap, rowspan, scope, valign, width
</p>


<h3> td </h3>
<p>
	The &lt; td&gt; tag defines a region in an image map.<br />
	align, bgcolor, border, cellspacing, cellpadding, frame, ruls, summary, width, tbody, align, char, chaoff, colspan, headers, height, nowrap, rowspan, scope, valign, width
</p>


<h3> tfoot </h3>
<p>
	The &lt; tfoot&gt; tag defines a region in an image map.<br />
	align, bgcolor, border, cellspacing, cellpadding, frame, ruls, summary, width, tbody, align, char, chaoff, colspan, headers, height, nowrap, rowspan, scope, valign, width
</p>


<h3> th </h3>
<p>
	The &lt; th&gt; tag defines a region in an image map.<br />
	align, bgcolor, border, cellspacing, cellpadding, frame, ruls, summary, width, tbody, align, char, chaoff, colspan, headers, height, nowrap, rowspan, scope, valign, width
</p>


<h3> thead </h3>
<p>
	The &lt; thead&gt; tag defines a region in an image map.<br />
	align, bgcolor, border, cellspacing, cellpadding, frame, ruls, summary, width, tbody, align, char, chaoff, colspan, headers, height, nowrap, rowspan, scope, valign, width
</p>


<h3> tr </h3>
<p>
	The &lt; tr&gt; tag defines a region in an image map.<br />
	align, bgcolor, border, cellspacing, cellpadding, frame, ruls, summary, width, tbody, align, char, chaoff, colspan, headers, height, nowrap, rowspan, scope, valign, width
</p>


<h3> tt </h3>
<p>
	The &lt; tt&gt; tag defines a region in an image map.<br />
	
</p>


<h3> ul </h3>
<p>
	The &lt; ul&gt; tag defines a region in an image map.<br />
	
</p>


<h3> toc </h3>
<p>
	The &lt; toc&gt; tag defines a region in an image map.<br />
	
</p>


<h3> interlink </h3>
<p>
	The &lt; interlink&gt; tag defines a region in an image map.<br />
	name
</p>


NOTES
remove applet, basefont, body, caption (code twicer?), font, title, u etc
? name, name, alt, char, title