<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


// PLUGIN: Barnraiser Core - comment

function plugin_comment ($attributes=null) {
	
	global $output_webspace,$body, $db, $core_config; 
	// PREPARE BLOCKS --------------------------------------------------------
	if (!isset($attributes['block'])) {
		$attributes['block'] = "comments";
	}

	if ($attributes['block'] == "comments") { // select multiple comments
		if (isset($_REQUEST[$attributes['item']])) {
			$item_id = $_REQUEST[$attributes['item']];

			if (!empty($_SESSION['connection_id'])) {
				$connection_id = $_SESSION['connection_id'];
			}
			else { // not logged in
				$connection_id = 0;
			}
			
			// paging...
			$query = "
				SELECT COUNT(*) AS total
				FROM " . $db->prefix . "_comment
				WHERE webspace_id=" . $output_webspace['webspace_id'] . " AND
				plugin_name=" . $db->qstr($attributes['plugin']) . " AND
				plugin_item_id=" . $item_id
			;
			$result = $db->Execute($query);
			if (isset($result[0]['total'])) {
				$total = $result[0]['total'];
				$body->set('total_nr_of_rows', $total);
			}
			$from = isset($_GET['_frmc']) ? (int) $_GET['_frmc'] : 0;
			// eo paging... 
			
			$query = "
				SELECT co.comment_id, co.comment_body, 
				UNIX_TIMESTAMP(co.comment_create_datetime) as comment_create_datetime, 
 				c.connection_nickname, c.connection_openid, 
 				COUNT(cr.connection_id) AS total_recommendations, co.connection_id, cr2.connection_id as recommendation_connection_id 
				FROM " . $db->prefix . "_comment co
 				INNER JOIN " . $db->prefix . "_connection c
 				ON co.connection_id=c.connection_id
				LEFT JOIN " . $db->prefix . "_comment_recommendation cr
				ON co.comment_id=cr.comment_id
				LEFT JOIN " . $db->prefix . "_comment_recommendation cr2
				ON (cr2.connection_id=" . $connection_id . "
				AND cr2.comment_id=co.comment_id)
				WHERE co.webspace_id=" . $output_webspace['webspace_id'] . " AND 
				co.plugin_name=" . $db->qstr($attributes['plugin']) . " AND 
				co.plugin_item_id=" . $item_id . "
				GROUP BY co.comment_id"
			;

			
  			
  			if (isset($_REQUEST['recommended'])) {
  				$query .= " ORDER BY total_recommendations DESC";
  			}
  			else {
	  			$query .= " ORDER BY co.comment_create_datetime";
	  		}
	
			//echo $query; exit;
	
			if (isset($attributes['limit'])) {
				$result = $db->Execute($query, (int) $attributes['limit']);
			}
			else {
				$result = $db->Execute($query, $core_config['display']['max_list_rows'], $from);
			}
			
			
	
			if (isset($result)) {
				$body->set('comments', $result);
				$body->set('item_id', $item_id);
				$body->set('plugin_name', $attributes['plugin']);
			}
		}
	}
	elseif ($attributes['block'] == "list") { // select multiple comments in simple list

		$query = "
			SELECT co.comment_id, co.comment_body, co.plugin_name, 
			UNIX_TIMESTAMP(co.comment_create_datetime) as comment_create_datetime,
			co.webspace_id, co.webpage_id, co.plugin_item_id 
			FROM " . $db->prefix . "_comment co 
			WHERE 
			co.webspace_id=" . $output_webspace['webspace_id'] . "
			ORDER BY co.comment_create_datetime DESC"
		;

		if (isset($attributes['limit'])) {
			$result = $db->Execute($query, (int) $attributes['limit']);
		}
		else {
			$result = $db->Execute($query);
		}

		if (isset($result)) {
			foreach($result as $key => $i):
				$result[$key]['comment_body'] = strip_tags($result[$key]['comment_body']);

				if (strlen($result[$key]['comment_body']) > 80) {
					$result[$key]['comment_body'] = str_replace_dots($result[$key]['comment_body'], 80);
				}

				$url = "index.php?ws=" . $i['webspace_id'] . "&amp;wp=" . $i['webpage_id'];
				
				// append link with correct item type
				if (isset($i['plugin_name'])) {

					if (is_file("components/" .$i['plugin_name'] . "/inc/plugin_item_declaration.inc.php")) {
						include_once ("components/" . $i['plugin_name']. "/inc/plugin_item_declaration.inc.php");

						$function_name = "am_plugin_" . $i['plugin_name'] . "_getItemTableName";
						
						if (function_exists($function_name)) {
							$item_item_url = $function_name();
							$url .= "&amp;" . $item_item_url . "=" . $i['plugin_item_id'];
						}
					}
				}
				
				$url .= "#comment_id" . $i['comment_id'];
				$result[$key]['link'] = $url;
				
			endforeach;
			
			$body->set('comments', $result);
		}
	}
}

?>