<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


function checkPermission ($plugin, $resource, $permission) {

	global $db;

	$query = "
		SELECT bitwise_operator
		FROM " . $db->prefix . "_permission
		WHERE
		plugin_name=" . $db->qstr($plugin) . " AND
		resource_name=" . $db->qstr($resource)
	;
	
	$result = $db->Execute($query);
	
	if (isset($result[0])) {
		if ($result[0]['bitwise_operator'] & intval($permission)) {
			return true;
		}
	}

	return false;
}


function highlight($search, $txt, $color=1) {

	//remove all html
	$pattern = array ("'<script[^>]*?>.*?</script>'si", // Strip out javascript
		"'<[\/\!]*?[^<>]*?>'si",// Strip out HTML tags
       	"'([\r\n])[\s]+'",  // Strip out white space
       	"'&(quot|#34);'i" // Replace HTML entities
	);

	$replace = array ("",
       	"",
       	"\\1",
		"\""
	);

	$txt = preg_replace($pattern, $replace, $txt);

	$search = explode('+', $search);
	
	//show 20 chars before first highlighted word
	$search_start_pos = (strlen($txt) - strlen(stristr($txt,$search[0]))-20);
	
	if ($search_start_pos > 20) {
		$txt = substr($txt,$search_start_pos);
		$txt = "..." . $txt;
	}

	//reduce string length to 150 char
	if (strlen($txt) > 150) {
		$txt = substr($txt,0, 160);
		$txt = $txt . "...";
	}
	
	if ($color == 1) {
		foreach($search as $key => $s):
			$txt = preg_replace("/(" . trim($s) . ")/i","<span class='txt_search_highlight'>\\0</span>",$txt);
		endforeach;
	}
	return $txt;
}


function paging($total, $display, $url_base, $extension='') {

	if ($total <= $display) {
		return "";
	}

	if (isset($_GET['_frm' . $extension]) && is_numeric($_GET['_frm' . $extension])) {
		$from = $_GET['_frm' . $extension];
	}
	else {
		$from = 0;
	}
	
	$to = $from + $display;

	$listnav = "<div class=\"listnav\">";

	
	if (substr($url_base, -3, 3) == "php") {
		$url_base = $url_base . "?";
	}
	else {
		$url_base = $url_base . "&";
	}
	
	
	if ($from == 0) {
		$listnav .= "<a href=\"". $url_base . "_frm" . $extension . "=0\" class=\"active\">&laquo;&laquo;</a> ";
	}
	else {
		$listnav .= "<a href=\"". $url_base . "_frm" . $extension . "=0\">&laquo;&laquo;</a> ";
	}
	
	if ($from == 0) {
		$listnav .= "<a href=\"". $url_base . "_frm" . $extension . "=0\" class=\"active\">&laquo;</a> ";
	}
	else {
		$listnav .= "<a href=\"". $url_base . "_frm" . $extension . "=" . ($from - $display) ."\">&laquo;</a> ";
	}
	
	for ($i = 0; $i <= ceil($total/($display))-1; $i++) {
		if ($display*$i >= $from && $display*$i < $to) {
			$listnav .= "<a href=\"" . $url_base . "_frm" . $extension . "=" . $i*$display . "\" class=\"active\">" . (int) ($i+1) . "</a> ";
		}
		else {
			$listnav .= "<a href=\"" . $url_base . "_frm" . $extension . "=" . $i*$display . "\">" . (int) ($i+1) . "</a> ";
		}
	}
	
	if ($from <= $total && $to >= $total) {
		$listnav .= "<a href=\"". $url_base . "_frm" . $extension . "=" . $from . "\" class=\"active\">&raquo;</a> ";
	}
	else {
		$listnav .= "<a href=\"". $url_base . "_frm" . $extension . "=" . $to ."\">&raquo;</a> ";
	}
	
	if ($from <= $total && $to >= $total) {
		$listnav .= "<a href=\"". $url_base . "_frm" . $extension . "=" . ($i-1)*$display ."\" class=\"active\">&raquo;&raquo;</a> ";
	}
	else {
		$listnav .= "<a href=\"". $url_base . "_frm" . $extension . "=" . ($i-1)*$display ."\">&raquo;&raquo;</a> ";
	}
	
	$listnav .= "</div>";
	
	return $listnav;
}


// content parser
// Main parse-function
function am_parse($str) {
	if (!get_magic_quotes_gpc()) {
		$str = stripslashes($str);
	}

	$str = str_replace("\r", "", $str);

	
	// process <code>
	$pattern = "/<code>(.*?)?<\/code>/s";

 	if (preg_match_all($pattern, $str, $code_blocks)) {
 		
		if (!empty($code_blocks[1])) {
			foreach ($code_blocks[1] as $key => $i):
				$replace = $code_blocks[1][$key];
				$replace = trim($replace);
				$replace = htmlspecialchars($replace);
				$replace = "<code>\n" . $replace . "\r</code>";
				$str = str_replace($code_blocks[0][$key], $replace, $str);
			endforeach;
		}
	}
	
	$str = _nl2br(nls2p($str));


	// Making links active
    $pattern = '#(^|[^"\'=\]]{1})(http|HTTP|ftp)(s|S)?://([^\s<>\.]+)\.([^\s<>]+)#sm';
    $replace = '\\1<a href="\\2\\3://\\4.\\5">\\2\\3://\\4.\\5</a>';
    $str = preg_replace($pattern, $replace, $str);
	
	return $str;
}


// content parser
function nls2p($str) {
	// temporary - we need to do something clever here to ignore inside code tags and
	// no wrap paras around html tags
	$str = str_replace('<p></p>', '', '<p>' . preg_replace('#([\r\n]\s*?[\r\n]){1,}#', '</p>$0<p>', $str) . '</p><br />');
	
	return $str;
}


// content parser
function _nl2br($str) {
	$str = preg_replace( "/([0-9A-Za-z.!?])\n/", "$1<br />", $str);

	return $str;
}


// content parser
function am_render($str) {

	$str = str_replace("<p>", "", $str);
	$str = str_replace("</p>", "", $str);

	// process <code>
	$pattern = "/<code>(.*?)?<\/code>/s";

 	if (preg_match_all($pattern, $str, $code_blocks)) {
 	
		if (!empty($code_blocks[1])) {
			foreach ($code_blocks[1] as $key => $i):
				$replace = str_replace("<br />", "", $code_blocks[1][$key]);
				$replace = "<code>" . $replace . "</code>";
				$str = str_replace($code_blocks[0][$key], $replace, $str);
			endforeach;
		}
	}
	$str = str_replace("<br />", "\n", $str);

	return trim($str);
}


// date output renderer
function am_strftime($datetime, $inc_time=null) {

	if (isset($inc_time)) {
		return utf8_encode(strftime("%d %b %G %H:%M", $datetime));
	}
	else {
		return utf8_encode(strftime("%d %b %G", $datetime));
	}
}


function str_replace_dots ($string, $size) {

	$string = mb_substr($string,0,$size, 'UTF-8');

	$string .= "...";

	return $string;
}


function formatSubDomainUrl ($webspace_unix_name=null) {

	global $core_config;

	if (!empty($core_config['am']['mode']) && $core_config['am']['mode'] > 0) { // single webspace configuration
		return "index.php";
	}
	else {
		// we take the unix name and attempt to create a full url
		if (isset($webspace_unix_name)) {
			// $_SERVER['HTTP_HOST'] returns site.name.domain and we need name.domain
			$domain_parts = explode('.', $_SERVER['HTTP_HOST'], 2);
			$domain = $domain_parts[1];
	
			return "http://" . $webspace_unix_name . "." . $domain;
		}
		else {
			return "http://" . $_SERVER['HTTP_HOST'];
		}
	}
}


if (!function_exists('scandir')) { // PHP5 only function, hence we declare for <PHP 5 installs
   function scandir($dir) {
       $files = array();
       $dh  = opendir($dir);
       while (false !== ($filename = readdir($dh))) {
           $files[] = $filename;
       }
       return $files;
   }
}

if (!function_exists('http_build_query')) {
    function http_build_query($formdata, $numeric_prefix = "")
    {
       $arr = array();
       foreach ($formdata as $key => $val)
         $arr[] = urlencode($numeric_prefix.$key)."=".urlencode($val);
       return implode($arr, "&");
    }
}

?>