<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------


// PLUGIN: Barnraiser Forum

function plugin_forum ($attributes=null) {
	
	global $db, $ws, $output_webspace, $body, $core_config;
	

	// PREPARE BLOCKS --------------------------------------------------------
	if (!isset($attributes['block'])) {
		$attributes['block'] = "subjects";
	}

	if ($attributes['block'] == "subjects") { // select multiple subjects
	
		// paging...
		$query = "
			SELECT COUNT(f.subject_id) AS total
			FROM " . $db->prefix . "_plugin_forum f "
		;
		
		if (!empty($attributes['webpagename'])) {
			$query .= ", " . $db->prefix . "_webpage wp ";
		}
		
		$query .= "WHERE f.webspace_id=" . $output_webspace['webspace_id'] . " AND
			f.subject_archived IS NULL ";

		if (!empty($attributes['webpagename'])) {
			$query .= " AND
				wp.webspace_id=" . $output_webspace['webspace_id'] . " AND
				wp.webpage_id=f.webpage_id AND
				wp.webpage_name=" . $db->qstr($attributes['webpagename'])
			;
		}
		
		$result = $db->Execute($query);
		
		if (isset($result[0]['total'])) {
			$total = $result[0]['total'];
			$body->set('total_nr_of_rows', $total);
		}
		$from = isset($_GET['_frm']) ? (int) $_GET['_frm'] : 0;
		// eo paging... 


		// select subjects
		$query = "
			SELECT s.subject_id, s.subject_title, s.subject_body, s.webpage_id 
			FROM " . $db->prefix . "_plugin_forum s"
		;

		if (!empty($attributes['webpagename'])) {
			$query .= ", " . $db->prefix . "_webpage wp ";
		}

		$query .= "
			WHERE 
			s.webspace_id=" . $output_webspace['webspace_id'] . " AND
			s.subject_archived IS NULL AND "
		;

		if (!empty($attributes['webpagename'])) {
			$query .= "
				wp.webspace_id=" . $output_webspace['webspace_id'] . " AND
				wp.webpage_id=s.webpage_id AND
				wp.webpage_name=" . $db->qstr($attributes['webpagename']) . " AND "
			;
		}

		$query .= "1=1 ORDER BY s.subject_sticky desc, s.subject_create_datetime";
		
		if (!isset($attributes['order'])) {
			$query .= " desc";
		}
		
		if (isset($attributes['limit'])) {
			$result = $db->Execute($query, (int) $attributes['limit']);

			$body->set('limit', $attributes['limit']);
		}
		else {
			$result = $db->Execute($query, $core_config['display']['max_list_rows'], $from);
		}

		if (!empty($result)) {

			$link = "index.php?ws=" . $output_webspace['webspace_id'];
			
			foreach($result as $key => $i):
				$result[$key]['subject_body'] = strip_tags($result[$key]['subject_body']);

				if (strlen($result[$key]['subject_body']) > 80) {
					$result[$key]['subject_body'] = substr_replace($result[$key]['subject_body'], '...', 80);
				}

				$result[$key]['link'] = $link . "&amp;wp=" . $i['webpage_id'] . "&amp;subject_id=" . $i['subject_id'];

			endforeach;

			if (!empty($attributes['webpagename'])) {
				$body->set('subject_webpagename', $attributes['webpagename']);
			}
		}
		elseif (isset($_SESSION['connection_permission']) && checkPermission('forum', 'add_forum_subject', $_SESSION['connection_permission']) && !empty($attributes['webpagename'])) {
			// We append the "no subjects" with a hint on how to add a subject
			global $lang;

			$url = "index.php?ws=" . $output_webspace['webspace_id'] . "&amp;wpn=" . $attributes['webpagename'];

			// check that the page is a valid page name
			$webpage_exists = $ws->selWebPages($attributes['webpagename']);

			if (!isset($webpage_exists[0]['webpage_name'])) {
				// we have a new page
				$url = "index.php?ws=" . $output_webspace['webspace_id'] . "&amp;t=admin_webpage&amp;wp=" . $output_webspace['webpage_id'] . "&amp;wpn=" . $attributes['webpagename'];
				$err_display_no_subjects = "<interlink name=\"" . $attributes['webpagename'] . "\">" . $lang['err_no_webpage'] . "</interlink>";
			}
			else {
				$lang['err_no_subjects_hint'] = str_replace('SYS_KEYWORD_URL', $url, $lang['err_no_subjects_hint']);

				$err_display_no_subjects = $lang['err_no_subjects'] . " " . $lang['err_no_subjects_hint'];

				$body->set('subject_webpagename', $attributes['webpagename']);
			}
			
		}
		else {
			global $lang;
			
			$err_display_no_subjects = $lang['err_no_subjects'];
		}


		// We push the array into a parent array - this is because we may have multiple listings
		// on a single page
		if (empty($result)) {
			$result['error_txt'] = $err_display_no_subjects;
		}

		$result = array($result);

		if (isset($body->vars['subjects'][0])) {
			$body->vars['subjects'] = $result;
		}
 		else {
			$body->set('subjects', $result);
 		}
	}
	elseif ($attributes['block'] == "subject") { // select single subject
		
		$query = "
			SELECT s.subject_id, s.subject_title, s.subject_body, 
			UNIX_TIMESTAMP(s.subject_create_datetime) as subject_create_datetime,
			UNIX_TIMESTAMP(s.subject_edit_datetime) as subject_edit_datetime,
			s.subject_locked, s.subject_sticky,
			c.connection_nickname, c.connection_openid, c.connection_id 
			FROM " . $db->prefix . "_plugin_forum s, " . $db->prefix . "_connection c
			WHERE
			s.connection_id=c.connection_id AND
			s.webspace_id=" . $output_webspace['webspace_id'] . " AND 
			s.webpage_id=" . $output_webspace['webpage_id'] . " AND "
		;

		if (isset($_REQUEST['subject_id'])) {
			$query .= "s.subject_id=" . $_REQUEST['subject_id'];
		}
		else { // if we do not get a subject_id we select the latest
			$query .= "s.subject_archived IS NULL ORDER BY s.subject_sticky desc, s.subject_create_datetime desc";
		}

		$result = $db->Execute($query);

		if (isset($result[0])) {
			$subject = $result[0];

			$_REQUEST['subject_id'] = $subject['subject_id'];

			if (!empty($subject['subject_locked'])) {
				$body->set('add_comment_locked', 1);
			}
			
			$body->set('subject', $subject);
		}
	}
}

?>