<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------


// PLUGIN: Barnraiser Wiki

function plugin_wiki ($attributes=null) {
	
	global $db, $ws, $output_webspace, $body, $wiki, $output_wikipage, $core_config;

	// PREPARE BLOCKS --------------------------------------------------------
	if (!isset($attributes['block'])) {
		$attributes['block'] = "wiki";
	}

	if ($attributes['block'] == "history" && isset($wiki['wikipage_id'])) { // select history of a page

		if (isset($wiki['wikipage_name'])) {
			$wikipage_name = $wiki['wikipage_name'];
		}
		elseif (isset($_REQUEST['wikipage_name'])) {
			$wikipage_name = $_REQUEST['wikipage_name'];
		}
		
		// paging...
		$query = "
			SELECT COUNT(r.revision_id) AS total
			FROM " . $db->prefix . "_plugin_wiki_revision r
			WHERE r.wikipage_id=" . $wiki['wikipage_id']
		;
		$result = $db->Execute($query);
		if (isset($result[0]['total'])) {
			$total = $result[0]['total'];
			$body->set('total_nr_of_rows', $total);
		}
		$from = isset($_GET['_frmw']) ? (int) $_GET['_frmw'] : 0;
		// eo paging... 
		
		if (isset($wikipage_name)) {
			$query = "
				SELECT wip.current_revision_id, r.revision_id,
				UNIX_TIMESTAMP(r.revision_create_datetime) as revision_create_datetime,
				c.connection_nickname, c.connection_openid, c.connection_id 
				FROM " . $db->prefix . "_plugin_wiki_page wip, " . $db->prefix . "_plugin_wiki_revision r, " . $db->prefix . "_connection c
				WHERE 
				wip.wikipage_name= " . $db->qstr($wikipage_name) . " AND
				r.connection_id=c.connection_id AND 
				wip.webspace_id=" . $output_webspace['webspace_id'] . " AND
				r.wikipage_id=" . $wiki['wikipage_id'] . "
				ORDER BY r.revision_create_datetime desc"
			;
			
			if (isset($attributes['limit']) && is_numeric($attributes['limit'])) {
				$result = $db->Execute($query, 0, $attributes['limit']);
			}
			else {
				$result = $db->Execute($query, $core_config['display']['max_list_rows'], $from);
			}
	
			if (isset($result)) {
	
				foreach($result as $key => $i):
					$result[$key]['link'] = "index.php?ws=" . $output_webspace['webspace_id'] . "&amp;wpn=" . $output_webspace['webpage_name'] . "&revision_id=" . $i['revision_id'];
					
				endforeach;
				
				$body->set('wiki_history', $result);
			}
		}
		
	}
	elseif ($attributes['block'] == "wiki") { // select single subject

		$query = "
			SELECT 
			wip.wikipage_id, r.revision_id, r.revision_body, r.connection_id,
			UNIX_TIMESTAMP(r.revision_create_datetime) as revision_create_datetime,
			wip.current_revision_id, wip.wikipage_name, 
			c.connection_nickname, c.connection_openid, c.connection_id 
			FROM " . $db->prefix . "_plugin_wiki_page wip, " . $db->prefix . "_plugin_wiki_revision r, " . $db->prefix . "_connection c
			WHERE 
			r.connection_id=c.connection_id AND "
		;

		if (isset($_REQUEST['revision_id'])) {
			$query .= " r.revision_id=" . $_REQUEST['revision_id'] . " AND r.wikipage_id=wip.wikipage_id AND ";
		}
		else {
			if (isset($_REQUEST['wikipage_name'])) {
				$query .= "wip.wikipage_name=" . $db->qstr($_REQUEST['wikipage_name']) . " AND ";
			}
			else {
				$query .= "wip.wikipage_name= " . $db->qstr($attributes['wikipage']) . " AND ";
			}
			
			$query .= "wip.current_revision_id=r.revision_id AND ";
		}

		$query .= "wip.webspace_id=" . $output_webspace['webspace_id'];
		
		$result = $db->Execute($query);
		
		if (isset($result[0])) {
			$wiki = $result[0];

			$_REQUEST['revision_id'] = $wiki['revision_id'];
		

			// WIKILINKING ------------------------------------------------
			$query = "
				SELECT DISTINCT wikipage_name
				FROM " . $db->prefix . "_plugin_wiki_page 
				WHERE
				webspace_id=" . $output_webspace['webspace_id']
			;
		
			$result = $db->Execute($query);
		
			if (isset($result)) {
				$pages = array();
	
				foreach ($result as $key => $i):
					array_push($pages, $i['wikipage_name']);
				endforeach;
			}
		
			$wikilink_path = "index.php?ws=" . $output_webspace['webspace_id'] . "&wp=" . $output_webspace['webpage_id'] . "&wikipage_name=";
			$wikilink_new_path = "index.php?ws=" . $output_webspace['webspace_id'] . "&t=edit_wikipage&c=wiki&wp=" . $output_webspace['webpage_id'] . "&wikipage_name=";
		
			// we run through the page body replacing any pages
			if (!empty($pages)) {
				foreach ($pages as $keyp => $p):
					// with anchors
					$pattern = "/<wikilink name=\"" . $p . "#(.*?)\">(.*?)<\/wikilink>/";
		
					$replacement = "<a href=\"" . $wikilink_path . $p . "#$1\">$2</a>";
		
					$wiki['revision_body'] = preg_replace($pattern, $replacement, $wiki['revision_body']);

					// without anchors
					$pattern = "/<wikilink name=\"" . $p . "\">(.*?)<\/wikilink>/";
		
					$replacement = "<a href=\"" . $wikilink_path . $p . "\">$1</a>";
		
					$wiki['revision_body'] = preg_replace($pattern, $replacement, $wiki['revision_body']);
				endforeach;
			}
		
			// now we look for new pages
			$pattern = "/<wikilink name=\"(.*?)\">(.*?)<\/wikilink>/";

			$replacement = "$2<a href=\"" . $wikilink_new_path . "$1\"><sup>?</sup></a>";
		
			$wiki['revision_body'] = preg_replace($pattern, $replacement, $wiki['revision_body']);


			// TOC
			$pattern = "/<toc>(.*?)<\/toc>/";
		
			if (preg_match($pattern, $wiki['revision_body'], $matches)) {
				$toc = "<div id=\"toc\">" . $matches[0] . "<br />";
				$toc .= "<ul>";
				
				// find h tags and order
				$h_pattern = "/<h(.*?)>(.*?)<\/h/";
				
				if (preg_match_all($h_pattern, $wiki['revision_body'], $matches)) {
					if (!empty($matches[2])) {
						foreach ($matches[2] as $key => $i):
							
							
	
							$toc .= "<li><a href=\"#atoc" . $key . "\">" . $i . "</a></li>";
							
							// get the H and apply anchor
							$a_pattern = "/<h" . $matches[1][$key] . ">" . $i . "<\/h" . $matches[1][$key] . ">/";
					
							$replacement = "<a name=\"atoc" . $key ."\"></a>\n<h" . $matches[1][$key] . ">" . $i . "</h" . $matches[1][$key] . ">";
							
						$wiki['revision_body'] = preg_replace($a_pattern, $replacement, $wiki['revision_body']);
						endforeach;
					}
					
				}
				
				$toc .= "</ul>";
				$toc .= "</div>";
				
				$wiki['revision_body'] = preg_replace($pattern, $toc, $wiki['revision_body']);
				
			}
			// EO TOC
			
			
			$body->set('wiki', $wiki);
		}
		else { // new wiki
			$wiki['revision_id'] = "";
			$wiki['current_revision_id'] = "";
			$wiki['revision_body'] = "";
			$wiki['connection_nickname'] = "";

			if (isset($_SESSION['connection_id'])) {
				$wiki['connection_id'] = $_SESSION['connection_id'];
			}
			
			$wiki['revision_create_datetime'] = time();
			$wiki['wikipage_name'] = $attributes['wikipage'];

			$body->set('wiki', $wiki);
		}
	}
}

?>