<?php

// ---------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// --------------------------------------------------------------------



// MAIN INCLUDES ---------------------------------------------------------
include_once ("../aroundme_c/core/config/core.config.php");
include_once ("../aroundme_c/core/inc/functions.inc.php");


// SESSION HANDLER -------------------------------------------------------
// sets up all session and global vars 
session_name($core_config['php']['session_name']);
session_start();


if (isset($_REQUEST['disconnect'])) {
	session_unset();
	session_destroy();
	session_write_close();
	header("Location: ../aroundme_c/maintain.php");
	exit;
}


// ERROR HANDLING
// this is accessed and updated with all errors thoughtout this build
// processing regularly checks if empty before continuing
$GLOBALS['am_error_log'] = array();



// SETUP TEMPLATE -------------------------------------------
define("AM_TEMPLATE_PATH", "../installation/template/");
require_once('../aroundme_c/core/class/Template.class.php');
$tpl = new Template();


// SETUP LANGUAGE --------------------------------------------
$_SESSION['language_code'] = $core_config['language']['pack'][$core_config['language']['default_pack_id']];
$locale_code = $core_config['language']['localization'][strtoupper($_SESSION['language_code'])];
setlocale(LC_ALL, $locale_code);

$lang = array();

define("AM_LANGUAGE_PATH", "language/" . $_SESSION['language_code'] . "/");

include_once(AM_LANGUAGE_PATH . 'installer.lang.php');


// SETUP OPENID -------------------------------------------
include '../aroundme_c/core/class/OpenidConsumer.class.php';
$openid_consumer = new OpenidConsumer;



if (isset($_POST['start_install'])) {

	// set the session_id
	$php_session_name = 'PHPSESSIDAMC';

	for($i = 0; $i < 4; $i++) {
		$n = rand(0, 9);
		$php_session_name .= $n;
	}
		
	writeToInstConfig('$core_config[\'php\'][\'session_name\']', $php_session_name);
	
	$tpl->set('display', 'setup_database');
}
elseif (isset($_POST['create_database'])) {

	$core_config['db']['host'] = $_POST['database_host'];
	$core_config['db']['user'] = $_POST['database_user'];
	$core_config['db']['pass'] = $_POST['database_password'];
	$core_config['db']['db'] = $_POST['database_db'];
	
	$connection = @mysql_connect($core_config['db']['host'], $core_config['db']['user'] ,$core_config['db']['pass']);

	if (!is_resource($connection)) {
		$GLOBALS['am_error_log'][] = array('db_error', mysql_error());
		$tpl->set('display', 'setup_database');
	}
	else {
		// We write the config
		writeToInstConfig('$core_config[\'db\'][\'host\']', $core_config['db']['host']);
		writeToInstConfig('$core_config[\'db\'][\'user\']', $core_config['db']['user']);
		writeToInstConfig('$core_config[\'db\'][\'pass\']', $core_config['db']['pass']);
		writeToInstConfig('$core_config[\'db\'][\'db\']', $core_config['db']['db']);
		
		// we create the database
		$query = "SET NAMES 'utf8'";

		mysql_query($query, $connection);

		$query = "SET CHARACTER SET 'utf8'";

		mysql_query($query, $connection);
		
		$query = "CREATE DATABASE " . $core_config['db']['db'] . " DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci";
		
		mysql_query($query, $connection);

		$db_selected = mysql_select_db($core_config['db']['db'], $connection);
		
		if (!$db_selected) {
			$GLOBALS['am_error_log'][] = array('db_select_error', mysql_error());
		}
		else {
			// we populate the database
			$queries = file_get_contents('../installation/install.sql');
	
			$pattern = "/CREATE(.*?);/s";
			
			if (preg_match_all($pattern, $queries, $matches)) {
				
				if (isset($matches[0])) {
					foreach ($matches[0] as $key => $i):
						$query = str_replace(';', '', $i);
						
						mysql_query($query, $connection);
					endforeach;
				}
			}
		}

		$tpl->set('display', 'setup_maintainer');
	}
}
elseif (isset($_POST['setup_webspace'])) {

	if ($_POST['webspace_creation_type'] == 2) {
		writeToInstConfig('$core_config[\'am\'][\'webspace_creation_type\']', 2);
	}
	elseif ($_POST['webspace_creation_type'] == 1) {
		writeToInstConfig('$core_config[\'am\'][\'webspace_creation_type\']', 1);
	}
	else {
		writeToInstConfig('$core_config[\'am\'][\'webspace_creation_type\']', 0);
	}


	// setup for subdomain
	$pattern = "/(.*?)\." . $_SERVER['HTTP_HOST'] . "/";
	$url = "http://REPLACE." . $_SERVER['HTTP_HOST'];
	

	writeToInstConfig('$core_config[\'am\'][\'domain_preg_pattern\']', $pattern);
	writeToInstConfig('$core_config[\'am\'][\'domain_replace_pattern\']', $url);

	// set the installation date MM-DD-YYYY
	$date = date("m-d-Y");
	writeToInstConfig('$core_config[\'release\'][\'install_date\']', $date);
	
	// set this file to not readable
	chmod ('../installation/installer.php', 0000); // disable this installer
	
	header("Location: maintain.php?installed=1");
	exit;
}
elseif (isset($_POST['connect'])) {
	
	// stage 2 - openid connect
	$_POST['openid_login'] = $openid_consumer->normalize($_POST['openid_login']);

	$openid_consumer->required_fields = array('nickname');

	if ($openid_consumer->discover($_POST['openid_login'])) { // we did discover a server
		if($openid_consumer->associate()) { // association is ok
			$openid_consumer->checkid_setup(); // do the setup
		}
		else {
			// error-log here
			$GLOBALS['am_error_log'][] = array('OpenID error - failed at associate');
			$tpl->set('display', 'setup_maintainer');
		}
	}
	else {
		// error-log here
		$GLOBALS['am_error_log'][] = array('OpenID error - failed at discovery');
		$tpl->set('display', 'setup_maintainer');
	}
}
elseif (isset($_GET['openid_mode']) && $_GET['openid_mode'] == 'id_res') { // we get data back from the server
	
	if ($openid_consumer->id_res()) { // was the result ok?

		$openid = $_GET['openid_identity'];

		if(substr($openid,-1,1) == '/'){
			$openid = substr($openid, 0, strlen($openid)-1);
		}

		writeToInstConfig('$core_config[\'am\'][\'maintainer_openids\'][]', $openid);
		
		$_SESSION['openid_identity'] = $openid;
		$_SESSION['openid_nickname'] = $_GET['openid_sreg_nickname'];
		$_SESSION['am_maintainer'] = 1;

		$tpl->set('display', 'setup_am');
		
	}
	else {
		// error-log here
		$GLOBALS['am_error_log'][] = array('openid_error');
		$tpl->set('display', 'setup_maintainer');
	}
	
}
else { // pre-start checks and setup

	if ( (int) phpversion() < 5) {
		$GLOBALS['am_error_log'][] = array('AROUNDMe collaboration server needs php 5.0 or greater. Your php version is ' . phpversion());
	}
	
	if (!function_exists('curl_init') || !function_exists('curl_setopt') || !function_exists('curl_exec')) {
		$GLOBALS['am_error_log'][] = array('AROUNDMe collaboration server needs curl. Please add curl to PHP');
	}
	
	if (!extension_loaded ('bcmath')) {
		$GLOBALS['am_error_log'][] = array('AROUNDMe collaboration server needs bcmath. Please add bcmath to PHP');
	}
	
	if (function_exists('gd_info')) {
		$gd_info = gd_info();
		
		if (!isset($gd_info['GD Version'])) {
			$GLOBALS['am_error_log'][] = array('AROUNDMe collaboration server needs gd library. Please add gd library to PHP');
		}
	}
	else {
		$GLOBALS['am_error_log'][] = array('AROUNDMe collaboration server needs gd library. Please add gd library to PHP');
	}
	
	if (!is_dir('../')) {
		$GLOBALS['am_error_log'][] = array('Directory structure not intact. You need to upload the entire release directory structure');
	}

	// check that we can write
	if (!is_writable("../aroundme_c/core/config/core.config.php")) {
		$GLOBALS['am_error_log'][] = array('AROUNDMe collaboration server cannot write to its config file. Please check your permissions');
	}
}


$tpl->set('lang', $lang);
$tpl->set('core_config', $core_config);
echo $tpl->fetch(AM_TEMPLATE_PATH . 'installer.tpl.php');


function writeToInstConfig($where, $what) {
	$config = file('../aroundme_c/core/config/core.config.php');
	foreach($config as $key => $val) {
		if (strstr($val, $where)) {
			$config[$key] = $where . ' = "' . $what . "\";\n";
			@file_put_contents('../aroundme_c/core/config/core.config.php', implode($config));
			break;
		}
	}
}

?>