<?php
// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>

<form name="upload_file" action="index.php?ws=<?php echo $webspace['webspace_id'];?>&amp;t=file" method="POST" enctype="multipart/form-data">
<input type="hidden" name="webpage_id" value="<?php if (isset($webpage['webpage_id'])) { echo $webpage['webpage_id'];}?>" />

<div id="am_core_area">
	<?php
	if(isset($_SESSION['connection_permission']) && checkPermission('core', 'upload_files', $_SESSION['connection_permission'])) {
	?>
	<table cellpadding="0" cellspacing="0" border="0">
		<tr>
			<td width="240" valign="top">
				<div class="box">
					<h1><?php echo $lang['hdr_files'];?></h1>
					
					<p>
						<?php echo $lang['txt_files'];?><br />
					</p>
	
					<ul>
						<li><a href="index.php?ws=<?php echo $webspace['webspace_id'];?>&amp;t=connect"><?php echo $lang['href_start_page']; ?></a></li>
					</ul>

					<?php if (isset($file_statistics)) { ?>
					
					<h1><?php echo $lang['txt_file_allocation']; ?></h1>
					<?php $percentage_used = $file_statistics['allocation'] == 0 ? 0 : (int) $file_statistics['allocation_used']/$file_statistics['allocation']*100;?>
						<table cellspacing="1" cellpadding="1" border="0" width="100%">
							<tr>
								<td width="<?php echo $percentage_used;?>%" class="bg1">
									<img src="<?php echo $template_path_core;?>img/pixel.png" width="1" height="6" alt="" /><br />
								</td>
								<td width="<?php echo 100 - $percentage_used;?>%" class="bg2">
									<img src="<?php echo $template_path_core;?>img/pixel.png" width="1" height="6" alt="" /><br />
								</td>
							</tr>
						</table>
					
					<?php } ?>
				</div>
				
			</td>
			<td width="30" style="border-right: 1px solid #333">
				<img src="<?php echo $template_path_core;?>img/pixel.png" width="30" height="1" border="0" alt="" /><br />
			</td>
			<td width="40">
				<img src="<?php echo $template_path_core;?>img/pixel.png" width="40" height="1" border="0" alt="" /><br />
			</td>
			<td valign="top" width="390">
				
					<h1><?php echo $lang['hdr_upload_file'];?></h1>
				
				<p>
					<label for="frm_file"><?php echo $lang['txt_file']; ?></label><br />
					<input type="file" name="frm_file" id="frm_file" /><br />
				</p>

				<p>
					<label for="frm_file_name"><?php echo $lang['txt_file_name']; ?></label><br />
					<input type="text" name="frm_file_name" id="frm_file_name" value=""/><br />
				</p>
				
				<p>
					<i><?php echo $lang['txt_width_intro']; ?></i>
				</p>
				
				<p>
					<label for="frm_file_name"><?php echo $lang['txt_width']; ?></label><br />
					<input type="text" name="file_width" size="4" value=""/>
					&nbsp;<img src="<?php echo $template_path_core;?>img/measure.png" width="150" height="12" border="0" alt="" />
					&nbsp;pixels
					<br />
				</p>

				<p align="right">
					<input type="submit" name="submit_file_upload" value="<?php echo $lang['txt_upload']; ?>" class="input_submit" /><br />
				</p>
			</td>
		</tr>
	</table>

	<hr />
	<?php }?>

	<?php if (isset($file_image)) { ?>
	<div class="box">
		
		
		<h1><?php echo $lang['hdr_selected_file']; ?></h1>
		
			<img src="components/core/relay/get_file.php?file=<?php echo $file_image['file_md5_name']; ?>" class="picture" /><br />
			<p>
			<b><?php echo $lang['txt_file_title']; ?></b>: <?php echo $file_image['file_title']; ?><br />
			<b><?php echo $lang['txt_file_uploaded']; ?></b>: <?php echo $file_image['file_create_datetime']; ?><br />
			<b><?php echo $lang['txt_file_size']; ?></b>: <?php echo $file_image['file_size']; ?> kb<br />
			<b><?php echo $lang['txt_file_width']; ?></b>: <?php echo $file_image['file_width']; ?><br />
			<b><?php echo $lang['txt_file_height']; ?></b>: <?php echo $file_image['file_height']; ?><br />
			<?php
				$external_image_tag = htmlentities("<img src=\"" . $file_image['global_path'] . "\" alt=\"\" height=\"" . $file_image['file_height'] . "\" width=\"" . $file_image['file_width'] . "\" />");
			?>
			<label for="id_readonly_global_path"><?php echo $lang['txt_external_tag']; ?></label> <input type="text" id="id_readonly_global_path" name="readonly_global_path" onclick="javascript:document.upload_file.readonly_global_path.focus();document.upload_file.readonly_global_path.select();" readonly="true" value="<?php echo $external_image_tag; ?>"/><br />
			<input type="hidden" name="file_id" value="<?php echo $file_image['file_id']; ?>"/>
			<input type="submit" name="delete_file" value="<?php echo $lang['txt_delete_image']; ?>" />
			</p>
	</div>

	<hr />
	<?php } ?>

	<div class="box">
		<h1><?php echo $lang['hdr_images'];?></h1>
		
		<?php if (isset($files['images'])) { ?>
			<?php foreach($files['images'] as $i): ?>
				<div style="float: left; padding-right: 10px; padding-bottom: 10px;">
					<a href="index.php?ws=<?php echo $_REQUEST['ws'];?>&amp;t=file&amp;file_md5_name=<?php echo $i['file_md5_name']; ?>"><img style="border: 1px solid black; cursor: pointer;" src="components/core/relay/get_file.php?file=<?php echo $i['file_md5_name']; ?>_t" title="<?php echo $i['file_title']; ?>. <?php echo $lang['txt_file_uploaded']; ?> <?php echo $i['file_create_datetime']; ?>. <?php echo $lang['txt_click_view']; ?>" /></a>
				</div>
			<?php endforeach; ?>
		<?php } ?>
		<div style="clear: both;"></div>
	</div>

	<hr />
	
	<div class="box">
		<h1><?php echo $lang['hdr_files'];?></h1>
		
		<?php if (isset($files['application']) && !empty($files['application'])) { ?>
		
			<script type="text/javascript">
				
				var state = false;
				
				
			</script>
			<table width="100%" id="id_file_list">
				<tr>
					<th>&nbsp;</th>
					<th align="left"><a title="click to sort by title" href="index.php?ws=<?php echo $webspace['webspace_id'];?>&amp;t=file&amp;sort_by=file_title<?php if (!isset($_REQUEST['desc'])) echo '&desc=1'; ?>#id_file_list">title</a></th>
					<th align="left"><a title="click to sort by type" href="index.php?ws=<?php echo $webspace['webspace_id'];?>&amp;t=file&amp;sort_by=file_type<?php if (!isset($_REQUEST['desc'])) echo '&desc=1'; ?>#id_file_list">type</a></th>
					<th align="left"><a title="click to sort by uploadtime" href="index.php?ws=<?php echo $webspace['webspace_id'];?>&amp;t=file&amp;sort_by=file_create_datetime<?php if (!isset($_REQUEST['desc'])) echo '&desc=1'; ?>#id_file_list">uploaded</a></th>
					<th align="left"><?php echo $lang['txt_external_tag_url'];?></th>
					<th align="left" id="id_table_header"><?php echo $lang['txt_check_to_delete'];?></th>
				</tr>
				<?php foreach($files['application'] as $f): ?>
				
				<?php
					$external_file_tag = htmlentities("<a href=\"" . $f['global_path'] . "\">" . $f['file_title'] . "</a>");
				?>
				
				<tr title="click to check" id="id_file_row_<?php echo $f['file_id']; ?>" style="cursor: pointer;" onclick="check_uncheck('id_delete_file[<?php echo $f['file_id']; ?>]', 'id_file_row_<?php echo $f['file_id']; ?>');">
					
						<?php if ($f['file_type'] == $core_config['file']['mime'][4]['mime']) { ?>
							<td><img src="<?php echo $template_path; ?>img/file_pdf.png" /></td>
						<?php } elseif ($f['file_type'] == $core_config['file']['mime'][5]['mime']) { ?>
							<td><img src="<?php echo $template_path; ?>img/file_plain.png" /></td>
						<?php } ?>
					<td>
						<a href="components/core/relay/get_file.php?file=<?php echo  $f['file_md5_name']; ?>" onclick="check_uncheck('<?php echo $f['file_id']; ?>');"><?php echo $f['file_title']; ?></a>
					</td>
					<td><?php echo $f['file_type']; ?></td>
					<td><?php echo $f['file_create_datetime']; ?></td>
					<td onclick="check_uncheck('id_delete_file[<?php echo $f['file_id']; ?>]', 'id_file_row_<?php echo $f['file_id']; ?>');"><input type="text" id="id_global_path_<?php echo $f['file_id']; ?>" name="readonly_global_path_<?php echo $f['file_id']; ?>" onclick="javascript:document.upload_file.readonly_global_path_<?php echo $f['file_id']; ?>.focus();document.upload_file.readonly_global_path_<?php echo $f['file_id']; ?>.select();" readonly="true" value="<?php echo $external_file_tag; ?>"/></td>
					<td align="left">
						<input type="checkbox" id="id_delete_file[<?php echo $f['file_id']; ?>]" onclick="check_uncheck('id_delete_file[<?php echo $f['file_id']; ?>]', 'id_file_row_<?php echo $f['file_id']; ?>');" name="delete_file[<?php echo $f['file_id']; ?>]"/>
						<label for="id_delete_file[<?php echo $f['file_id']; ?>]" style="width: 30px;">&nbsp;</label>
					</td>
				</tr>
				
				<?php endforeach; ?>
			</table>
			<p align="right">
				<input type="submit" name="delete_files" value="delete selected files" class="input_submit" />
			</p>
		<?php } ?>
	</div>
</div>