/* Move all of the deletes and renames to their final resting place.

  Copyright (C) 2003, 2004 Walter Landry
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 dated June, 1991.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
  USA */

#include "boost/filesystem/operations.hpp"
#include "boost/filesystem/convenience.hpp"
#include "Moved_Path.hpp"
#include <list>
#include <sstream>
#include "Checksums.hpp"
#include "unsafe_move_inventory_id.hpp"

using namespace std;
using namespace boost;
namespace fs=boost::filesystem;
using fs::path;

/* The root parameter is only if we have to move inventory ids. */

void move_original_away(const path &root,
                        const path &source, const path &destination,
                        list<pair<string,string> > &conflicts,
                        const Checksums &checksums)
{
  /* If there is a conflict, rename the original to .orig.
     This may also conflict, so try .orig1, .orig2, ... until
     we find one that works. */
  stringstream orig(".orig");
  int counter(0);
  
  while(fs::lexists(destination.string() + orig.str()))
    {
      ++counter;
      orig.str("");
      orig << ".orig" << counter;
    }
  
  conflicts.push_back(make_pair(destination.string(),
                                destination.string() + orig.str()));

  string inventory_id;
  for(Checksums::const_iterator i=checksums.begin(); i!=checksums.end(); ++i)
    {
      if(i->first.file_path.string()==source.string())
        {
          inventory_id=i->first.inventory_id;
          break;
        }
    }
  if(!inventory_id.empty())
    unsafe_move_inventory_id(root,source,destination.string() + orig.str(),
                             inventory_id);
  rename(source,(destination.string() + orig.str()));
}

void move_original_away(const path &root, const path &destination,
                        list<pair<string,string> > &conflicts,
                        const Checksums &checksums)
{
  move_original_away(root,destination,destination,conflicts,
                     checksums);
}

void move_original_away(const path &root, const path &source,
                        const path &destination,
                        list<pair<string,string> > &conflicts)
{
  move_original_away(root,source,destination,conflicts,Checksums());
}
